/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableShortList
extends AbstractMutableList<Short>
implements MutableList<Short>,
RandomAccess {
    private final MutableShortList delegate;

    public BoxedMutableShortList(MutableShortList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Short item) {
        return this.delegate.add(item.shortValue());
    }

    public boolean addAll(int index, Collection<? extends Short> c) {
        short[] target = new short[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Short get(int index) {
        return this.delegate.get(index);
    }

    public Short set(int index, Short element) {
        return this.delegate.set(index, element.shortValue());
    }

    public void add(int index, Short element) {
        this.delegate.addAtIndex(index, element.shortValue());
    }

    public Short remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Short ? this.delegate.indexOf(((Short)o).shortValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Short ? this.delegate.lastIndexOf(((Short)o).shortValue()) : -1;
    }

    @Override
    public MutableList<Short> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

