/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteBytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ByteByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteByteMaps;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableByteByteSingletonMap
implements ImmutableByteByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final byte key1;
    private final byte value1;

    ImmutableByteByteSingletonMap(byte key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public byte get(byte key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(byte key, byte ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public byte getOrThrow(byte key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ByteBytePair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableByteByteMap flipUniqueValues() {
        return ByteByteMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableByteByteMap select(ByteBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ByteByteHashMap().toImmutable();
    }

    public ImmutableByteByteMap reject(ByteBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ByteByteHashMap().toImmutable() : ByteByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new ByteIterable[]{ByteBags.immutable.with(this.value1)});
    }

    public ImmutableByteByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)ByteByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public byte min() {
        return this.value1;
    }

    public byte max() {
        return this.value1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteHashBag.newBagWith(this.value1).toImmutable() : ByteBags.immutable.empty();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteBags.immutable.empty() : ByteHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    public boolean contains(byte value) {
        return this.value1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableByteByteMap newWithKeyValue(byte key, byte value) {
        return ByteByteMaps.immutable.withAll((ByteByteMap)ByteByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableByteByteMap newWithoutKey(byte key) {
        return this.key1 == key ? ByteByteMaps.immutable.with() : this;
    }

    public ImmutableByteByteMap newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ByteByteMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of((MutableByteCollection)ByteArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteByteMap)) {
            return false;
        }
        ByteByteMap map = (ByteByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

