/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.platform.ComponentContainer;

public abstract class Container {
    protected ComponentContainer container;

    public ComponentContainer container() {
        return this.container;
    }

    public final void init() {
        this.init(new ComponentContainer());
    }

    public final void init(ComponentContainer container) {
        this.container = container;
        this.configure();
    }

    public final Container installChild(Container child) {
        ComponentContainer childContainer = this.container.createChild();
        child.init(childContainer);
        return child;
    }

    public final void uninstallChild() {
        this.container.removeChild();
    }

    public final Container start() {
        this.container.startComponents();
        this.doStart();
        return this;
    }

    protected void doStart() {
    }

    public final Container stop() {
        try {
            this.doStop();
            this.container.stopComponents();
            this.container.removeChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    protected void doStop() {
    }

    protected abstract void configure();
}

