/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.Event;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;

public class PastSnapshotFinderByPreviousVersion
implements BatchExtension {
    private final DatabaseSession session;

    public PastSnapshotFinderByPreviousVersion(DatabaseSession session) {
        this.session = session;
    }

    PastSnapshot findByPreviousVersion(Snapshot projectSnapshot) {
        String currentVersion = projectSnapshot.getVersion();
        Integer resourceId = projectSnapshot.getResourceId();
        String hql = "from " + Event.class.getSimpleName() + " where name<>:version AND category='Version' AND resourceId=:resourceId ORDER BY date DESC";
        List events = this.session.createQuery(hql).setParameter("version", (Object)currentVersion).setParameter("resourceId", (Object)resourceId).setMaxResults(1).getResultList();
        if (events.isEmpty()) {
            return new PastSnapshot("previous_version");
        }
        Event previousVersionEvent = (Event)events.get(0);
        Snapshot snapshot = (Snapshot)this.session.getSingleResult(Snapshot.class, new Object[]{"id", previousVersionEvent.getSnapshot().getId()});
        return new PastSnapshot("previous_version", snapshot.getCreatedAt(), snapshot).setModeParameter(snapshot.getVersion());
    }
}

