/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.picocontainer.ComponentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.DefaultProfileLoader;
import org.sonar.batch.DefaultProjectClasspath;
import org.sonar.batch.DefaultProjectFileSystem2;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectSettings;
import org.sonar.batch.bootstrap.UnsupportedProperties;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.batch.local.DryRunExporter;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.core.qualitymodel.DefaultModelFinder;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;

public class ProjectModule
extends Module {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectModule.class);
    private Project project;

    public ProjectModule(Project project) {
        this.project = project;
    }

    protected void configure() {
        this.logSettings();
        this.addCoreComponents();
        this.addPluginExtensions();
    }

    private void addCoreComponents() {
        ProjectDefinition projectDefinition = ((ProjectTree)this.container.getComponentByType(ProjectTree.class)).getProjectDefinition(this.project);
        this.container.addSingleton((Object)projectDefinition);
        this.container.addSingleton((Object)this.project.getConfiguration());
        this.container.addSingleton((Object)this.project);
        this.container.addSingleton(ProjectSettings.class);
        this.container.getComponentByType(ProjectSettings.class);
        this.container.addSingleton(EventBus.class);
        this.container.addSingleton(Phases.class);
        this.container.addSingleton(PhasesTimeProfiler.class);
        for (Class clazz : Phases.getPhaseClasses()) {
            this.container.addSingleton((Object)clazz);
        }
        this.container.addSingleton(UnsupportedProperties.class);
        for (Class<Object> component : projectDefinition.getContainerExtensions()) {
            this.container.addSingleton(component);
        }
        this.container.addSingleton(Languages.class);
        this.container.addSingleton(DefaultProjectClasspath.class);
        this.container.addSingleton(DefaultProjectFileSystem2.class);
        this.container.addSingleton(RulesDao.class);
        this.container.addSingleton((Object)((ResourcePersister)this.container.getComponentByType(ResourcePersister.class)).getSnapshot((Resource)this.project));
        this.container.addSingleton(TimeMachineConfiguration.class);
        this.container.addSingleton(MeasuresDao.class);
        this.container.addSingleton(ProfilesDao.class);
        this.container.addSingleton(DefaultSensorContext.class);
        this.container.addSingleton(BatchExtensionDictionnary.class);
        this.container.addSingleton(DefaultTimeMachine.class);
        this.container.addSingleton(ViolationFilters.class);
        this.container.addSingleton(ResourceFilters.class);
        this.container.addSingleton(DefaultModelFinder.class);
        this.container.addSingleton(DefaultProfileLoader.class);
        this.container.addSingleton(DryRunExporter.class);
        this.container.addPicoAdapter((ComponentAdapter)new ProfileProvider());
    }

    private void addPluginExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.container.getComponentByType(ExtensionInstaller.class);
        installer.install(this.container, "PER_PROJECT");
    }

    private void logSettings() {
        LOG.info("-------------  Analyzing {}", (Object)this.project.getName());
    }

    protected void doStart() {
        DefaultIndex index = (DefaultIndex)((Object)this.container.getComponentByType(DefaultIndex.class));
        index.setCurrentProject(this.project, (ResourceFilters)this.container.getComponentByType(ResourceFilters.class), (ViolationFilters)this.container.getComponentByType(ViolationFilters.class), (RulesProfile)this.container.getComponentByType(RulesProfile.class));
        ((Phases)this.container.getComponentByType(Phases.class)).execute(this.project);
    }
}

