/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.configuration.PropertiesConfiguration;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.UriReader;
import org.sonar.batch.FakeMavenPluginExecutor;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.bootstrap.BatchModule;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BatchSettings;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.PluginDownloader;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.core.config.Logback;

public class BootstrapModule
extends Module {
    private Object[] boostrapperComponents;
    private ProjectReactor reactor;

    public BootstrapModule(ProjectReactor reactor, Object ... boostrapperComponents) {
        this.reactor = reactor;
        this.boostrapperComponents = boostrapperComponents;
    }

    protected void configure() {
        this.container.addSingleton((Object)this.reactor);
        this.container.addSingleton((Object)new PropertiesConfiguration());
        this.container.addSingleton(BootstrapSettings.class);
        this.container.addSingleton(ServerClient.class);
        this.container.addSingleton(BatchSettings.class);
        this.container.addSingleton(BatchPluginRepository.class);
        this.container.addSingleton(ExtensionInstaller.class);
        this.container.addSingleton(Logback.class);
        this.container.addSingleton(ServerMetadata.class);
        this.container.addSingleton(org.sonar.batch.ServerMetadata.class);
        this.container.addSingleton(TempDirectories.class);
        this.container.addSingleton(HttpDownloader.class);
        this.container.addSingleton(UriReader.class);
        this.container.addSingleton(PluginDownloader.class);
        for (Object component : this.boostrapperComponents) {
            if (component == null) continue;
            this.container.addSingleton(component);
        }
        if (!this.isMavenPluginExecutorRegistered()) {
            this.container.addSingleton(FakeMavenPluginExecutor.class);
        }
    }

    boolean isMavenPluginExecutorRegistered() {
        if (this.boostrapperComponents != null) {
            for (Object component : this.boostrapperComponents) {
                if (!(component instanceof Class) || !MavenPluginExecutor.class.isAssignableFrom((Class)component)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doStart() {
        Module batchComponents = this.installChild(new BatchModule());
        batchComponents.start();
    }
}

