/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProfileLoader;
import org.sonar.jpa.dao.ProfilesDao;

public class DefaultProfileLoader
implements ProfileLoader {
    private ProfilesDao dao;
    private Settings settings;

    public DefaultProfileLoader(ProfilesDao dao, Settings settings) {
        this.dao = dao;
        this.settings = settings;
    }

    public RulesProfile load(Project project) {
        String profileName = StringUtils.defaultIfBlank((String)this.settings.getString("sonar.profile"), (String)this.settings.getString("sonar.profile." + project.getLanguageKey()));
        if (StringUtils.isBlank((String)profileName)) {
            throw new SonarException("You must install a plugin that supports the language '" + project.getLanguageKey() + "'");
        }
        RulesProfile profile = this.dao.getProfile(project.getLanguageKey(), profileName);
        if (profile == null) {
            throw new SonarException("Quality profile not found : " + profileName + ", language " + project.getLanguageKey());
        }
        return this.hibernateHack(profile);
    }

    private RulesProfile hibernateHack(RulesProfile profile) {
        profile.getActiveRules().size();
        for (ActiveRule activeRule : profile.getActiveRules()) {
            activeRule.getActiveRuleParams().size();
            activeRule.getRule().getParams().size();
        }
        profile.getAlerts().size();
        return profile;
    }
}

