/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.DefaultIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeMachine
implements TimeMachine {
    private DatabaseSession session;
    private DefaultIndex index;
    private MetricFinder metricFinder;

    public DefaultTimeMachine(DatabaseSession session, DefaultIndex index, MetricFinder metricFinder) {
        this.session = session;
        this.index = index;
        this.metricFinder = metricFinder;
    }

    public List<Measure> getMeasures(TimeMachineQuery query) {
        Map<Integer, Metric> metricById = this.getMetricsById(query);
        List objects = this.execute(query, true, metricById.keySet());
        ArrayList result = Lists.newArrayList();
        for (Object[] object : objects) {
            MeasureModel model = (MeasureModel)object[0];
            Measure measure = DefaultTimeMachine.toMeasure(model, metricById.get(model.getMetricId()));
            measure.setDate((Date)object[1]);
            result.add(measure);
        }
        return result;
    }

    public List<Object[]> getMeasuresFields(TimeMachineQuery query) {
        Map<Integer, Metric> metricById = this.getMetricsById(query);
        List rows = this.execute(query, false, metricById.keySet());
        for (Object[] fields : rows) {
            fields[1] = metricById.get(fields[1]);
        }
        return rows;
    }

    protected List execute(TimeMachineQuery query, boolean selectAllFields, Set<Integer> metricIds) {
        Resource resource = query.getResource();
        if (resource != null && resource.getId() == null) {
            resource = this.index.getResource(query.getResource());
        }
        if (resource == null) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        HashMap params = Maps.newHashMap();
        if (selectAllFields) {
            sb.append("SELECT m, s.createdAt ");
        } else {
            sb.append("SELECT s.createdAt, m.metricId, m.value ");
        }
        sb.append(" FROM ").append(MeasureModel.class.getSimpleName()).append(" m, ").append(Snapshot.class.getSimpleName()).append(" s WHERE m.snapshotId=s.id AND s.resourceId=:resourceId AND s.status=:status AND s.qualifier<>:lib");
        params.put("resourceId", resource.getId());
        params.put("status", "P");
        params.put("lib", "LIB");
        sb.append(" AND m.characteristic IS NULL");
        sb.append(" AND m.personId IS NULL");
        sb.append(" AND m.ruleId IS NULL AND m.rulePriority IS NULL");
        if (!metricIds.isEmpty()) {
            sb.append(" AND m.metricId IN (:metricIds) ");
            params.put("metricIds", metricIds);
        }
        if (query.isFromCurrentAnalysis()) {
            sb.append(" AND s.createdAt>=:from ");
            params.put("from", this.index.getProject().getAnalysisDate());
        } else if (query.getFrom() != null) {
            sb.append(" AND s.createdAt>=:from ");
            params.put("from", query.getFrom());
        }
        if (query.isToCurrentAnalysis()) {
            sb.append(" AND s.createdAt<=:to ");
            params.put("to", this.index.getProject().getAnalysisDate());
        } else if (query.getTo() != null) {
            sb.append(" AND s.createdAt<=:to ");
            params.put("to", query.getTo());
        }
        if (query.isOnlyLastAnalysis()) {
            sb.append(" AND s.last=:last ");
            params.put("last", Boolean.TRUE);
        }
        sb.append(" ORDER BY s.createdAt ");
        Query jpaQuery = this.session.createQuery(sb.toString());
        for (Map.Entry entry : params.entrySet()) {
            jpaQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        return jpaQuery.getResultList();
    }

    public Map<Integer, Metric> getMetricsById(TimeMachineQuery query) {
        Collection metrics = this.metricFinder.findAll(query.getMetricKeys());
        HashMap result = Maps.newHashMap();
        for (Metric metric : metrics) {
            result.put(metric.getId(), metric);
        }
        return result;
    }

    static Measure toMeasure(MeasureModel model, Metric metric) {
        Measure measure = new Measure(metric);
        measure.setId(model.getId());
        measure.setDescription(model.getDescription());
        measure.setValue(model.getValue());
        measure.setData(model.getData(metric));
        measure.setAlertStatus(model.getAlertStatus());
        measure.setAlertText(model.getAlertText());
        measure.setTendency(model.getTendency());
        measure.setVariation1(model.getVariationValue1());
        measure.setVariation2(model.getVariationValue2());
        measure.setVariation3(model.getVariationValue3());
        measure.setVariation4(model.getVariationValue4());
        measure.setVariation5(model.getVariationValue5());
        measure.setUrl(model.getUrl());
        measure.setCharacteristic(model.getCharacteristic());
        measure.setPersonId(model.getPersonId());
        return measure;
    }
}

