/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.batch.MavenPluginExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostJobsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PostJobsExecutor.class);
    private Collection<PostJob> postJobs;
    private MavenPluginExecutor mavenExecutor;
    private ProjectDefinition projectDefinition;
    private Project project;

    public PostJobsExecutor(BatchExtensionDictionnary selector, Project project, ProjectDefinition projectDefinition, MavenPluginExecutor mavenExecutor) {
        this(selector.select(PostJob.class, project, true), project, projectDefinition, mavenExecutor);
    }

    PostJobsExecutor(Collection<PostJob> jobs, Project project, ProjectDefinition projectDefinition, MavenPluginExecutor mavenExecutor) {
        this.postJobs = jobs;
        this.mavenExecutor = mavenExecutor;
        this.project = project;
        this.projectDefinition = projectDefinition;
    }

    public void execute(SensorContext context) {
        this.logPostJobs();
        for (PostJob postJob : this.postJobs) {
            LOG.info("Executing post-job {}", postJob.getClass());
            this.executeMavenPlugin(postJob);
            postJob.executeOn(this.project, context);
        }
    }

    private void logPostJobs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Post-jobs : {}", (Object)StringUtils.join(this.postJobs, (String)" -> "));
        }
    }

    private void executeMavenPlugin(PostJob job) {
        MavenPluginHandler handler;
        if (job instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)job).getMavenPluginHandler(this.project)) != null) {
            this.mavenExecutor.execute(this.project, this.projectDefinition, handler);
        }
    }
}

