/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DecoratorsSelector;
import org.sonar.batch.DefaultDecoratorContext;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.phases.DecoratorExecutionEvent;
import org.sonar.batch.phases.DecoratorsPhaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorsExecutor
implements BatchComponent {
    private DecoratorsSelector decoratorsSelector;
    private SonarIndex index;
    private EventBus eventBus;

    public DecoratorsExecutor(BatchExtensionDictionnary extensionDictionnary, SonarIndex index, EventBus eventBus) {
        this.decoratorsSelector = new DecoratorsSelector(extensionDictionnary);
        this.index = index;
        this.eventBus = eventBus;
    }

    public void execute(Project project) {
        Collection<Decorator> decorators = this.decoratorsSelector.select(project);
        this.eventBus.fireEvent(new DecoratorsPhaseEvent(Lists.newArrayList(decorators), true));
        this.decorateResource((Resource)project, decorators, true);
        this.eventBus.fireEvent(new DecoratorsPhaseEvent(Lists.newArrayList(decorators), false));
    }

    DecoratorContext decorateResource(Resource resource, Collection<Decorator> decorators, boolean executeDecorators) {
        ArrayList childrenContexts = Lists.newArrayList();
        Iterator i$ = this.index.getChildren(resource).iterator();
        while (i$.hasNext()) {
            Resource child;
            boolean isModule = (child = (Resource)i$.next()) instanceof Project;
            DefaultDecoratorContext childContext = (DefaultDecoratorContext)this.decorateResource(child, decorators, !isModule);
            childrenContexts.add(childContext.setReadOnly(true));
        }
        DefaultDecoratorContext context = new DefaultDecoratorContext(resource, this.index, childrenContexts);
        if (executeDecorators) {
            for (Decorator decorator : decorators) {
                this.executeDecorator(decorator, context, resource);
            }
        }
        return context;
    }

    void executeDecorator(Decorator decorator, DefaultDecoratorContext context, Resource resource) {
        try {
            this.eventBus.fireEvent(new DecoratorExecutionEvent(decorator, true));
            decorator.decorate(resource, (DecoratorContext)context);
            this.eventBus.fireEvent(new DecoratorExecutionEvent(decorator, false));
        }
        catch (Exception e) {
            throw new SonarException("Fail to decorate '" + resource + "'", (Throwable)e);
        }
    }
}

