/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.utils.Logs;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachineConfiguration
implements BatchExtension {
    private static final int NUMBER_OF_VARIATION_SNAPSHOTS = 5;
    private final Configuration configuration;
    private List<PastSnapshot> projectPastSnapshots;

    public TimeMachineConfiguration(Configuration configuration, PastSnapshotFinder pastSnapshotFinder, Snapshot projectSnapshot) {
        this.configuration = configuration;
        this.initPastSnapshots(pastSnapshotFinder, projectSnapshot);
    }

    private void initPastSnapshots(PastSnapshotFinder pastSnapshotFinder, Snapshot projectSnapshot) {
        this.projectPastSnapshots = Lists.newLinkedList();
        for (int index = 1; index <= 5; ++index) {
            PastSnapshot pastSnapshot = pastSnapshotFinder.find(projectSnapshot, this.configuration, index);
            if (pastSnapshot == null) continue;
            this.log(pastSnapshot);
            this.projectPastSnapshots.add(pastSnapshot);
        }
    }

    private void log(PastSnapshot pastSnapshot) {
        String qualifier = pastSnapshot.getQualifier();
        if (StringUtils.equals((String)"VW", (String)qualifier) || StringUtils.equals((String)"SVW", (String)qualifier)) {
            LoggerFactory.getLogger(this.getClass()).debug(pastSnapshot.toString());
        } else {
            Logs.INFO.info(pastSnapshot.toString());
        }
    }

    public TimeMachineConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.projectPastSnapshots = Collections.emptyList();
    }

    public boolean skipTendencies() {
        return this.configuration.getBoolean("sonar.skipTendencies", false);
    }

    public int getTendencyPeriodInDays() {
        return this.configuration.getInt("tendency.depth", 30);
    }

    public List<PastSnapshot> getProjectPastSnapshots() {
        return this.projectPastSnapshots;
    }
}

