/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDefinition {
    private static final String PROJECT_SOURCES_PROPERTY = "sonar.sources";
    private static final String PROJECT_TESTS_PROPERTY = "sonar.tests";
    private static final String PROJECT_BINARIES_PROPERTY = "sonar.binaries";
    private static final String PROJECT_LIBRARIES_PROPERTY = "sonar.libraries";
    private static final char SEPARATOR = ',';
    private File baseDir;
    private File workDir;
    private Properties properties;
    private List<ProjectDefinition> modules = Lists.newArrayList();
    private List<Object> containerExtensions = Lists.newArrayList();

    public ProjectDefinition(File baseDir, File workDir, Properties properties) {
        this.baseDir = baseDir;
        this.workDir = workDir;
        this.properties = properties;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void appendProperty(String key, String value) {
        String newValue = this.properties.getProperty(key, "") + ',' + value;
        this.properties.put(key, newValue);
    }

    public List<String> getSourceDirs() {
        String sources = this.properties.getProperty(PROJECT_SOURCES_PROPERTY, "");
        return Arrays.asList(StringUtils.split((String)sources, (char)','));
    }

    public void addSourceDir(String path) {
        this.appendProperty(PROJECT_SOURCES_PROPERTY, path);
    }

    public List<String> getTestDirs() {
        String sources = this.properties.getProperty(PROJECT_TESTS_PROPERTY, "");
        return Arrays.asList(StringUtils.split((String)sources, (char)','));
    }

    public void addTestDir(String path) {
        this.appendProperty(PROJECT_TESTS_PROPERTY, path);
    }

    public List<String> getBinaries() {
        String sources = this.properties.getProperty(PROJECT_BINARIES_PROPERTY, "");
        return Arrays.asList(StringUtils.split((String)sources, (char)','));
    }

    public void addBinaryDir(String path) {
        this.appendProperty(PROJECT_BINARIES_PROPERTY, path);
    }

    public List<String> getLibraries() {
        String sources = this.properties.getProperty(PROJECT_LIBRARIES_PROPERTY, "");
        return Arrays.asList(StringUtils.split((String)sources, (char)','));
    }

    public void addLibrary(String path) {
        this.appendProperty(PROJECT_LIBRARIES_PROPERTY, path);
    }

    public void addContainerExtension(Object extension) {
        this.containerExtensions.add(extension);
    }

    public List<Object> getContainerExtensions() {
        return this.containerExtensions;
    }

    public void addModule(ProjectDefinition projectDefinition) {
        this.modules.add(projectDefinition);
    }

    public List<ProjectDefinition> getModules() {
        return this.modules;
    }
}

