/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import java.util.List;
import org.sonar.api.batch.Event;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.batch.index.SourcePersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPersistenceManager
implements PersistenceManager {
    private ResourcePersister resourcePersister;
    private SourcePersister sourcePersister;
    private MeasurePersister measurePersister;
    private DependencyPersister dependencyPersister;
    private LinkPersister linkPersister;
    private EventPersister eventPersister;

    public DefaultPersistenceManager(ResourcePersister resourcePersister, SourcePersister sourcePersister, MeasurePersister measurePersister, DependencyPersister dependencyPersister, LinkPersister linkPersister, EventPersister eventPersister) {
        this.resourcePersister = resourcePersister;
        this.sourcePersister = sourcePersister;
        this.measurePersister = measurePersister;
        this.dependencyPersister = dependencyPersister;
        this.linkPersister = linkPersister;
        this.eventPersister = eventPersister;
    }

    @Override
    public void clear() {
        this.resourcePersister.clear();
        this.sourcePersister.clear();
    }

    @Override
    public void setDelayedMode(boolean b) {
        this.measurePersister.setDelayedMode(b);
    }

    @Override
    public void dump() {
        this.measurePersister.dump();
    }

    @Override
    public void saveProject(Project project, Project parent) {
        this.resourcePersister.saveProject(project, parent);
    }

    @Override
    public Snapshot saveResource(Project project, Resource resource, Resource parent) {
        if (ResourceUtils.isPersistable((Resource)resource)) {
            return this.resourcePersister.saveResource(project, resource, parent);
        }
        return null;
    }

    @Override
    public void setSource(Resource file, String source) {
        this.sourcePersister.saveSource(file, source);
    }

    @Override
    public void saveMeasure(Resource resource, Measure measure) {
        if (ResourceUtils.isPersistable((Resource)resource)) {
            this.measurePersister.saveMeasure(resource, measure);
        }
    }

    @Override
    public Measure reloadMeasure(Measure measure) {
        return this.measurePersister.reloadMeasure(measure);
    }

    @Override
    public void saveDependency(Project project, Dependency dependency, Dependency parentDependency) {
        if (ResourceUtils.isPersistable((Resource)dependency.getFrom()) && ResourceUtils.isPersistable((Resource)dependency.getTo())) {
            this.dependencyPersister.saveDependency(project, dependency, parentDependency);
        }
    }

    @Override
    public void saveLink(Project project, ProjectLink link) {
        this.linkPersister.saveLink(project, link);
    }

    @Override
    public void deleteLink(Project project, String key) {
        this.linkPersister.deleteLink(project, key);
    }

    @Override
    public List<Event> getEvents(Resource resource) {
        return this.eventPersister.getEvents(resource);
    }

    @Override
    public void deleteEvent(Event event) {
        this.eventPersister.deleteEvent(event);
    }

    @Override
    public void saveEvent(Resource resource, Event event) {
        if (ResourceUtils.isPersistable((Resource)resource)) {
            this.eventPersister.saveEvent(resource, event);
        }
    }
}

