/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.ResourcePersister;

public class DefaultPersister
extends ResourcePersister {
    public DefaultPersister(DatabaseSession session) {
        super(session);
    }

    protected Snapshot createSnapshot(Bucket bucket, ResourceModel resourceModel) {
        Snapshot parentSnapshot = bucket.getParent() != null ? bucket.getParent().getSnapshot() : null;
        Snapshot snapshot = new Snapshot(resourceModel, parentSnapshot);
        return snapshot;
    }

    protected void prepareResourceModel(ResourceModel resourceModel, Bucket bucket) {
        resourceModel.setRootId(bucket.getProject() != null ? bucket.getProject().getResourceId() : null);
    }

    protected String generateEffectiveKey(Bucket bucket) {
        return new StringBuilder(400).append(bucket.getProject().getResource().getKey()).append(':').append(bucket.getResource().getKey()).toString();
    }
}

