/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.Plugin;
import org.sonar.api.batch.AbstractCoverageExtension;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ServerMetadata;
import org.sonar.core.classloaders.ClassLoadersCollection;
import org.sonar.core.plugin.AbstractPluginRepository;
import org.sonar.core.plugin.JpaPlugin;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.core.plugin.JpaPluginFile;

public class BatchPluginRepository
extends AbstractPluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private String baseUrl;
    private JpaPluginDao dao;
    private ClassLoadersCollection classLoaders;

    public BatchPluginRepository(JpaPluginDao dao, ServerMetadata server) {
        this.dao = dao;
        this.baseUrl = server.getURL() + "/deploy/plugins/";
    }

    BatchPluginRepository() {
    }

    public void start() {
        this.classLoaders = new ClassLoadersCollection(Thread.currentThread().getContextClassLoader());
        for (JpaPlugin pluginMetadata : this.dao.getPlugins()) {
            String key = pluginMetadata.getKey();
            ArrayList urls = Lists.newArrayList();
            for (JpaPluginFile pluginFile : pluginMetadata.getFiles()) {
                try {
                    URL url = new URL(this.baseUrl + pluginFile.getPath());
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    throw new SonarException("Can not build the classloader of the plugin " + pluginFile.getPluginKey(), (Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Classloader of plugin " + key + ":");
                for (URL url : urls) {
                    LOG.debug("   -> " + url);
                }
            }
            this.classLoaders.createClassLoader(key, (Collection)urls, pluginMetadata.isUseChildFirstClassLoader() == Boolean.TRUE);
        }
        this.classLoaders.done();
    }

    public void registerPlugins(MutablePicoContainer pico) {
        for (JpaPlugin pluginMetadata : this.dao.getPlugins()) {
            try {
                Class<?> claz = this.classLoaders.get(pluginMetadata.getKey()).loadClass(pluginMetadata.getPluginClass());
                Plugin plugin = (Plugin)claz.newInstance();
                this.registerPlugin(pico, plugin, pluginMetadata.getKey());
            }
            catch (Exception e) {
                throw new SonarException("Fail to load extensions from plugin " + pluginMetadata.getKey(), (Throwable)e);
            }
        }
        this.invokeExtensionProviders(pico);
    }

    protected boolean shouldRegisterExtension(PicoContainer container, String pluginKey, Object extension) {
        boolean ok = BatchPluginRepository.isType((Object)extension, BatchExtension.class);
        if (ok && BatchPluginRepository.isType((Object)extension, AbstractCoverageExtension.class) && !(ok = this.shouldRegisterCoverageExtension(pluginKey, (Project)container.getComponent(Project.class), (Configuration)container.getComponent(Configuration.class)))) {
            LOG.debug("The following extension is ignored: " + extension + ". See the parameter " + "sonar.core.codeCoveragePlugin");
        }
        return ok;
    }

    boolean shouldRegisterCoverageExtension(String pluginKey, Project project, Configuration conf) {
        boolean ok = true;
        if (StringUtils.equals((String)project.getLanguageKey(), (String)"java")) {
            Object[] selectedPluginKeys = conf.getStringArray("sonar.core.codeCoveragePlugin");
            if (ArrayUtils.isEmpty((Object[])selectedPluginKeys)) {
                selectedPluginKeys = new String[]{"cobertura"};
            }
            ok = ArrayUtils.contains((Object[])selectedPluginKeys, (Object)pluginKey);
        }
        return ok;
    }
}

