/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.ResourcePersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPersister
extends ResourcePersister<Project> {
    public ProjectPersister(DatabaseSession session) {
        super(session);
    }

    @Override
    protected String generateEffectiveKey(Bucket<Project> bucket) {
        return bucket.getResource().getKey();
    }

    @Override
    protected void prepareResourceModel(ResourceModel resourceModel, Bucket<Project> bucket) {
        if (bucket.getProject() != null) {
            resourceModel.setRootId(bucket.getProject().getResourceId());
        }
        resourceModel.setLanguageKey(bucket.getResource().getLanguageKey());
    }

    @Override
    protected Snapshot createSnapshot(Bucket<Project> bucket, ResourceModel resourceModel) {
        Project project = bucket.getResource();
        Snapshot parentSnapshot = bucket.getParent() != null ? bucket.getParent().getSnapshot() : null;
        Snapshot snapshot = new Snapshot(resourceModel, parentSnapshot);
        snapshot.setVersion(project.getAnalysisVersion());
        snapshot.setCreatedAt(project.getAnalysisDate());
        return snapshot;
    }
}

