/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.HashMultimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.Plugin;
import org.sonar.api.batch.AbstractCoverageExtension;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.RemoteClassLoader;
import org.sonar.batch.ServerMetadata;
import org.sonar.core.plugin.AbstractPluginRepository;
import org.sonar.core.plugin.JpaPlugin;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.core.plugin.JpaPluginFile;

public class BatchPluginRepository
extends AbstractPluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private Map<String, ClassLoader> classloaders;
    private String baseUrl;
    private JpaPluginDao dao;

    public BatchPluginRepository(JpaPluginDao dao, ServerMetadata server) {
        this.dao = dao;
        this.baseUrl = server.getUrl() + "/deploy/plugins/";
    }

    BatchPluginRepository() {
    }

    public void start() {
        HashMultimap urlsByKey = HashMultimap.create();
        for (JpaPluginFile pluginFile : this.dao.getPluginFiles()) {
            try {
                String key = this.getClassloaderKey(pluginFile.getPluginKey());
                URL url = new URL(this.baseUrl + pluginFile.getPath());
                urlsByKey.put((Object)key, (Object)url);
            }
            catch (MalformedURLException e) {
                throw new SonarException("Can not build the classloader of the plugin " + pluginFile.getPluginKey(), (Throwable)e);
            }
        }
        this.classloaders = new HashMap<String, ClassLoader>();
        for (String key : urlsByKey.keySet()) {
            Set urls = urlsByKey.get((Object)key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Classloader of plugin " + key + ":");
                for (URL url : urls) {
                    LOG.debug("   -> " + url);
                }
            }
            this.classloaders.put(key, new RemoteClassLoader(urls, Thread.currentThread().getContextClassLoader()).getClassLoader());
        }
    }

    private String getClassloaderKey(String pluginKey) {
        return "sonar-plugin-" + pluginKey;
    }

    public void registerPlugins(MutablePicoContainer pico) {
        for (JpaPlugin pluginMetadata : this.dao.getPlugins()) {
            try {
                String classloaderKey = this.getClassloaderKey(pluginMetadata.getKey());
                Class<?> claz = this.classloaders.get(classloaderKey).loadClass(pluginMetadata.getPluginClass());
                Plugin plugin = (Plugin)claz.newInstance();
                this.registerPlugin(pico, plugin, pluginMetadata.getKey());
            }
            catch (Exception e) {
                throw new SonarException("Fail to load extensions from plugin " + pluginMetadata.getKey(), (Throwable)e);
            }
        }
        this.invokeExtensionProviders(pico);
    }

    private String getOldCoveragePluginKey(String pluginKey) {
        if (StringUtils.equals((String)"sonar-jacoco-plugin", (String)pluginKey)) {
            return "jacoco";
        }
        if (StringUtils.equals((String)"sonar-emma-plugin", (String)pluginKey)) {
            return "emma";
        }
        return null;
    }

    protected boolean shouldRegisterExtension(PicoContainer container, String pluginKey, Object extension) {
        boolean ok = BatchPluginRepository.isType((Object)extension, BatchExtension.class);
        if (ok && BatchPluginRepository.isType((Object)extension, AbstractCoverageExtension.class) && !(ok = this.shouldRegisterCoverageExtension(pluginKey, (Project)container.getComponent(Project.class), (Configuration)container.getComponent(Configuration.class)))) {
            LOG.debug("The following extension is ignored: " + extension + ". See the parameter " + "sonar.core.codeCoveragePlugin");
        }
        return ok;
    }

    boolean shouldRegisterCoverageExtension(String pluginKey, Project project, Configuration conf) {
        boolean ok = true;
        if (StringUtils.equals((String)project.getLanguageKey(), (String)"java")) {
            Object[] selectedPluginKeys = conf.getStringArray("sonar.core.codeCoveragePlugin");
            if (ArrayUtils.isEmpty((Object[])selectedPluginKeys)) {
                selectedPluginKeys = new String[]{"cobertura"};
            }
            String oldCoveragePluginKey = this.getOldCoveragePluginKey(pluginKey);
            ok = ArrayUtils.contains((Object[])selectedPluginKeys, (Object)pluginKey) || ArrayUtils.contains((Object[])selectedPluginKeys, (Object)oldCoveragePluginKey);
        }
        return ok;
    }
}

