/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.net.URLClassLoader;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugins;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.IocContainer;
import org.sonar.api.utils.ServerHttpClient;
import org.sonar.batch.BatchPluginRepository;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectBatch;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.RemoteClassLoader;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.indexer.DefaultSonarIndex;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.jpa.session.DatabaseSessionProvider;
import org.sonar.jpa.session.DriverDatabaseConnector;
import org.sonar.jpa.session.ThreadLocalDatabaseSessionFactory;

public class Batch {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private Configuration configuration;
    private Object[] components;

    public Batch(Configuration configuration, Object ... components) {
        this.configuration = configuration;
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MutablePicoContainer container = null;
        try {
            container = this.buildPicoContainer();
            container.start();
            this.analyzeProjects(container);
        }
        finally {
            if (container != null) {
                container.stop();
            }
        }
    }

    private void analyzeProjects(MutablePicoContainer container) {
        MutablePicoContainer batchContainer = container.makeChildContainer();
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ServerMetadata.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProjectTree.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultResourceCreationLock.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultSonarIndex.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(JpaPluginDao.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(BatchPluginRepository.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(Plugins.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ServerHttpClient.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(HttpDownloader.class);
        batchContainer.start();
        ProjectTree projectTree = (ProjectTree)batchContainer.getComponent(ProjectTree.class);
        DefaultSonarIndex index = (DefaultSonarIndex)((Object)batchContainer.getComponent(DefaultSonarIndex.class));
        this.analyzeProject(batchContainer, index, projectTree.getRootProject());
    }

    private MutablePicoContainer buildPicoContainer() {
        MutablePicoContainer container = IocContainer.buildPicoContainer();
        this.register(container, this.configuration);
        URLClassLoader fullClassloader = RemoteClassLoader.createForJdbcDriver(this.configuration).getClassLoader();
        Thread.currentThread().setContextClassLoader(fullClassloader);
        this.register(container, new DriverDatabaseConnector(this.configuration, (ClassLoader)fullClassloader));
        this.register(container, ThreadLocalDatabaseSessionFactory.class);
        container.as(new Properties[]{Characteristics.CACHE}).addAdapter((ComponentAdapter)new DatabaseSessionProvider());
        for (Object component : this.components) {
            this.register(container, component);
        }
        return container;
    }

    private void register(MutablePicoContainer container, Object component) {
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(component);
    }

    private void analyzeProject(MutablePicoContainer container, DefaultSonarIndex index, Project project) {
        for (Project module : project.getModules()) {
            this.analyzeProject(container, index, module);
        }
        LOG.info("-------------  Analyzing " + project.getName());
        new ProjectBatch(container).execute(index, project);
    }
}

