/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.sonar.api.utils.IocContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module {
    private MutablePicoContainer container;

    public final Module init() {
        return this.init(IocContainer.buildPicoContainer());
    }

    private Module init(MutablePicoContainer container) {
        this.container = container;
        this.configure();
        return this;
    }

    public final Module install(Module module) {
        module.init(this.container);
        return this;
    }

    public final Module installChild(Module child) {
        MutablePicoContainer childContainer = this.container.makeChildContainer();
        childContainer.addComponent((Object)new IocContainer(childContainer));
        childContainer.setName(child.toString());
        child.init(childContainer);
        return child;
    }

    public final void uninstallChild(Module child) {
        this.container.removeChildContainer((PicoContainer)child.container);
    }

    public final Module start() {
        this.container.start();
        this.doStart();
        return this;
    }

    protected void doStart() {
    }

    public final Module stop() {
        try {
            this.doStop();
            this.container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    protected void doStop() {
    }

    protected abstract void configure();

    protected final void addComponent(Object component) {
        if (component instanceof Class) {
            this.container.as(new Properties[]{Characteristics.CACHE}).addComponent(component);
        } else {
            this.container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)(component.getClass().getCanonicalName() + "-" + component.toString()), component, new Parameter[0]);
        }
    }

    protected final void addComponent(Object componentKey, Object component) {
        this.container.as(new Properties[]{Characteristics.CACHE}).addComponent(componentKey, component, new Parameter[0]);
    }

    protected final void addAdapter(ComponentAdapter<?> componentAdapter) {
        this.container.addAdapter(componentAdapter);
    }

    public final <T> T getComponent(Class<T> componentType) {
        return (T)this.container.getComponent(componentType);
    }

    public final <T> List<T> getComponents(Class<T> componentType) {
        return this.container.getComponents(componentType);
    }

    public final MutablePicoContainer getContainer() {
        return this.container;
    }
}

