/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.net.URLClassLoader;
import org.apache.commons.configuration.Configuration;
import org.picocontainer.ComponentAdapter;
import org.sonar.api.Plugin;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.batch.FakeMavenPluginExecutor;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.bootstrap.ArtifactDownloader;
import org.sonar.batch.bootstrap.BatchExtensionInstaller;
import org.sonar.batch.bootstrap.BatchModule;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.JdbcDriverHolder;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectExtensionInstaller;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.jpa.session.DatabaseSessionProvider;
import org.sonar.jpa.session.DriverDatabaseConnector;
import org.sonar.jpa.session.ThreadLocalDatabaseSessionFactory;

public class BootstrapModule
extends Module {
    private Configuration configuration;
    private Object[] boostrapperComponents;
    private ProjectReactor reactor;

    public BootstrapModule(ProjectReactor reactor, Configuration configuration, Object ... boostrapperComponents) {
        this.reactor = reactor;
        this.configuration = configuration;
        this.boostrapperComponents = boostrapperComponents;
    }

    protected void configure() {
        this.addComponent(this.reactor);
        this.addComponent(this.configuration);
        this.addComponent(DryRun.class);
        this.addComponent(ServerMetadata.class);
        this.addComponent(TempDirectories.class);
        this.addComponent(HttpDownloader.class);
        this.addComponent(ArtifactDownloader.class);
        this.addComponent(JdbcDriverHolder.class);
        URLClassLoader bootstrapClassLoader = this.getComponent(JdbcDriverHolder.class).getClassLoader();
        Thread.currentThread().setContextClassLoader(bootstrapClassLoader);
        this.addComponent(new DriverDatabaseConnector(this.configuration, (ClassLoader)bootstrapClassLoader));
        this.addComponent(ThreadLocalDatabaseSessionFactory.class);
        this.addAdapter((ComponentAdapter<?>)new DatabaseSessionProvider());
        for (Object component : this.boostrapperComponents) {
            this.addComponent(component);
        }
        if (!this.isMavenPluginExecutorRegistered()) {
            this.addComponent(FakeMavenPluginExecutor.class);
        }
        this.addComponent(BatchPluginRepository.class);
        this.addComponent(BatchExtensionInstaller.class);
        this.addComponent(ProjectExtensionInstaller.class);
    }

    boolean isMavenPluginExecutorRegistered() {
        for (Object component : this.boostrapperComponents) {
            if (!(component instanceof Class) || !MavenPluginExecutor.class.isAssignableFrom((Class)component)) continue;
            return true;
        }
        return false;
    }

    protected void doStart() {
        this.addPlugins();
        boolean dryRun = this.getComponent(DryRun.class).isEnabled();
        Module batchComponents = this.installChild(new BatchModule(dryRun));
        batchComponents.start();
    }

    private void addPlugins() {
        for (Plugin plugin : this.getComponent(BatchPluginRepository.class).getPlugins()) {
            this.addComponent(plugin);
        }
    }
}

