/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.batch.indexer.DefaultSonarIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeMachine
implements TimeMachine {
    private DatabaseSession session;
    private DefaultSonarIndex index;
    private MeasuresDao measuresDao;

    public DefaultTimeMachine(DatabaseSession session, DefaultSonarIndex index, MeasuresDao measuresDao) {
        this.session = session;
        this.index = index;
        this.measuresDao = measuresDao;
    }

    public List<Measure> getMeasures(TimeMachineQuery query) {
        List objects = this.execute(query, true);
        ArrayList<Measure> result = new ArrayList<Measure>();
        for (Object[] object : objects) {
            MeasureModel model = (MeasureModel)object[0];
            Measure measure = model.toMeasure();
            measure.setDate((Date)object[1]);
            result.add(measure);
        }
        return result;
    }

    public List<Object[]> getMeasuresFields(TimeMachineQuery query) {
        return this.execute(query, false);
    }

    protected List execute(TimeMachineQuery query, boolean selectAllFields) {
        Resource resource = this.index.getResource(query.getResource());
        if (resource == null) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (selectAllFields) {
            sb.append("SELECT m, s.createdAt ");
        } else {
            sb.append("SELECT s.createdAt, m.metric, m.value ");
        }
        sb.append(" FROM " + MeasureModel.class.getSimpleName() + " m, " + Snapshot.class.getSimpleName() + " s WHERE m.snapshotId=s.id AND s.resourceId=:resourceId AND s.status=:status ");
        params.put("resourceId", resource.getId());
        params.put("status", "P");
        sb.append(" AND m.rule IS NULL AND m.rulePriority IS NULL AND m.rulesCategoryId IS NULL ");
        if (query.getMetrics() != null) {
            sb.append(" AND m.metric IN (:metrics) ");
            params.put("metrics", this.measuresDao.getMetrics(query.getMetrics()));
        }
        if (query.isFromCurrentAnalysis()) {
            sb.append(" AND s.createdAt>=:from ");
            params.put("from", this.index.getProject().getAnalysisDate());
        } else if (query.getFrom() != null) {
            sb.append(" AND s.createdAt>=:from ");
            params.put("from", query.getFrom());
        }
        if (query.isToCurrentAnalysis()) {
            sb.append(" AND s.createdAt<=:to ");
            params.put("to", this.index.getProject().getAnalysisDate());
        } else if (query.getTo() != null) {
            sb.append(" AND s.createdAt<=:to ");
            params.put("to", query.getTo());
        }
        if (query.isOnlyLastAnalysis()) {
            sb.append(" AND s.last=:last ");
            params.put("last", Boolean.TRUE);
        }
        sb.append(" ORDER BY s.createdAt ");
        Query jpaQuery = this.session.createQuery(sb.toString());
        for (Map.Entry entry : params.entrySet()) {
            jpaQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        return jpaQuery.getResultList();
    }
}

