/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugins;
import org.sonar.api.database.DatabaseSessionProvider;
import org.sonar.api.database.DriverDatabaseConnector;
import org.sonar.api.database.ThreadLocalDatabaseSessionFactory;
import org.sonar.api.plugins.ExtensionProvider;
import org.sonar.api.plugins.PluginProvider;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.IocContainer;
import org.sonar.batch.ProjectBatch;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.indexer.DefaultSonarIndex;

public class AggregatorBatch {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorBatch.class);
    private MutablePicoContainer topContainer;

    public AggregatorBatch(MavenSession mavenSession, MavenProject rootProject) {
        this.topContainer = AggregatorBatch.createContainer(mavenSession, rootProject);
    }

    private static MutablePicoContainer createContainer(MavenSession mavenSession, MavenProject rootProject) {
        MutablePicoContainer container = IocContainer.buildPicoContainer();
        container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)AggregatorBatch.getStartupConfiguration(rootProject));
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(DriverDatabaseConnector.class);
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(ThreadLocalDatabaseSessionFactory.class);
        container.addAdapter((ComponentAdapter)new DatabaseSessionProvider());
        container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)mavenSession);
        PluginProvider pluginProvider = new PluginProvider();
        ExtensionProvider extensionProvider = new ExtensionProvider(pluginProvider);
        container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)pluginProvider);
        container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)extensionProvider);
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(Plugins.class);
        return container;
    }

    public AggregatorBatch register(Object component) {
        this.topContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(component);
        return this;
    }

    private static Configuration getStartupConfiguration(MavenProject rootProject) {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)rootProject.getModel().getProperties()));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        try {
            this.topContainer.start();
            this.analyzeProjects();
        }
        finally {
            this.topContainer.stop();
        }
    }

    private void analyzeProjects() throws IOException {
        MutablePicoContainer batchContainer = this.topContainer.makeChildContainer();
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProjectTree.class);
        batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultSonarIndex.class);
        batchContainer.start();
        ProjectTree projectTree = (ProjectTree)batchContainer.getComponent(ProjectTree.class);
        DefaultSonarIndex index = (DefaultSonarIndex)((Object)batchContainer.getComponent(DefaultSonarIndex.class));
        this.analyzeProject(batchContainer, index, projectTree.getRootProject());
    }

    private void analyzeProject(MutablePicoContainer batchContainer, DefaultSonarIndex index, Project project) {
        for (Project module : project.getModules()) {
            this.analyzeProject(batchContainer, index, module);
        }
        LOG.info("-------------  Analyzing " + project.getName());
        new ProjectBatch(batchContainer).execute(index, project);
    }
}

