/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

public class CompilerMessage {
    private Kind kind;
    private int startline;
    private int startcolumn;
    private int endline;
    private int endcolumn;
    private String file;
    private String message;

    @Deprecated
    public CompilerMessage(String file, boolean error, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this.file = file;
        this.kind = error ? Kind.ERROR : Kind.WARNING;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
        this.message = message;
    }

    public CompilerMessage(String file, Kind kind, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this.file = file;
        this.kind = kind;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
        this.message = message;
    }

    @Deprecated
    public CompilerMessage(String message) {
        this.message = message;
        this.kind = Kind.WARNING;
    }

    @Deprecated
    public CompilerMessage(String message, boolean error) {
        this.message = message;
        this.kind = error ? Kind.ERROR : Kind.WARNING;
    }

    public CompilerMessage(String message, Kind kind) {
        this.message = message;
        this.kind = kind;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isError() {
        return this.kind == Kind.ERROR;
    }

    public int getStartLine() {
        return this.startline;
    }

    public int getStartColumn() {
        return this.startcolumn;
    }

    public int getEndLine() {
        return this.endline;
    }

    public int getEndColumn() {
        return this.endcolumn;
    }

    public String getMessage() {
        return this.message;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        if (this.file != null) {
            if (this.startline != 0) {
                if (this.startcolumn != 0) {
                    return this.file + ":" + "[" + this.startline + "," + this.startcolumn + "] " + this.message;
                }
                return this.file + ":" + "[" + this.startline + "] " + this.message;
            }
            return this.file + ": " + this.message;
        }
        return this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ERROR("error"),
        MANDATORY_WARNING("mandatory_warning"),
        NOTE("note"),
        OTHER("other"),
        WARNING("warning");

        private String type;

        private Kind(String type) {
            this.type = type;
        }
    }
}

