/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cdc;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.cdc.ComponentDescriptorCreator;
import org.codehaus.plexus.cdc.ComponentDescriptorCreatorException;
import org.codehaus.plexus.cdc.ComponentGleaner;
import org.codehaus.plexus.cdc.merge.MergeException;
import org.codehaus.plexus.cdc.merge.Merger;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DefaultComponentDescriptorCreator
extends AbstractLogEnabled
implements ComponentDescriptorCreator {
    private static final String LS = System.getProperty("line.separator");
    private ComponentGleaner gleaner;
    private Merger merger;

    public void processSources(File[] sourceDirectories, File outputFile) throws ComponentDescriptorCreatorException {
        this.processSources(sourceDirectories, outputFile, false, new ComponentDescriptor[0]);
    }

    public void processSources(File[] sourceDirectories, File outputFile, boolean containerDescriptor, ComponentDescriptor[] roleDefaults) throws ComponentDescriptorCreatorException {
        JavaDocBuilder builder = new JavaDocBuilder();
        this.getLogger().debug("Source directories: ");
        for (int it = 0; it < sourceDirectories.length; ++it) {
            File sourceDirectory = sourceDirectories[it];
            if (!sourceDirectory.isDirectory()) {
                this.getLogger().debug("Specified source directory isn't a directory: '" + sourceDirectory.getAbsolutePath() + "'.");
            }
            this.getLogger().debug(" - " + sourceDirectory.getAbsolutePath());
            builder.addSourceTree(sourceDirectory);
        }
        JavaSource[] javaSources = builder.getSources();
        HashMap<String, ComponentDescriptor> defaultsByRole = new HashMap<String, ComponentDescriptor>();
        if (roleDefaults != null) {
            for (int i = 0; i < roleDefaults.length; ++i) {
                defaultsByRole.put(roleDefaults[i].getRole(), roleDefaults[i]);
            }
        }
        ArrayList<ComponentDescriptor> componentDescriptors = new ArrayList<ComponentDescriptor>();
        for (int i = 0; i < javaSources.length; ++i) {
            JavaClass javaClass = this.getJavaClass(javaSources[i]);
            ComponentDescriptor componentDescriptor = this.gleaner.glean((JavaClassCache)builder, javaClass);
            if (componentDescriptor == null || javaClass.isAbstract()) continue;
            if (defaultsByRole.containsKey(componentDescriptor.getRole())) {
                ComponentDescriptor desc = (ComponentDescriptor)defaultsByRole.get(componentDescriptor.getRole());
                if (componentDescriptor.getInstantiationStrategy() == null) {
                    componentDescriptor.setInstantiationStrategy(desc.getInstantiationStrategy());
                }
            }
            componentDescriptors.add(componentDescriptor);
        }
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        componentSetDescriptor.setComponents(componentDescriptors);
        componentSetDescriptor.setDependencies(Collections.EMPTY_LIST);
        this.validateConfiguration(componentSetDescriptor);
        if (componentDescriptors.size() == 0 && componentSetDescriptor.getDependencies().size() == 0) {
            this.getLogger().debug("No components or dependencies found, not writing components.xml");
            return;
        }
        File parentFile = outputFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new ComponentDescriptorCreatorException("Could not make parent directory: '" + parentFile.getAbsolutePath() + "'.");
        }
        try {
            FileWriter writer = new FileWriter(outputFile);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
            w.startElement(containerDescriptor ? "plexus" : "component-set");
            this.writeComponents((XMLWriter)w, componentDescriptors);
            this.writeDependencies((XMLWriter)w, componentSetDescriptor);
            w.endElement();
            writer.write(LS);
            writer.close();
        }
        catch (PlexusConfigurationException e) {
            throw new ComponentDescriptorCreatorException("Internal error while writing out the configuration", e);
        }
        catch (IOException e) {
            throw new ComponentDescriptorCreatorException("Error while writing the component descriptor to: '" + outputFile.getAbsolutePath() + "'.", e);
        }
    }

    public void mergeDescriptors(File outputDescriptor, List descriptors) throws ComponentDescriptorCreatorException {
        SAXBuilder builder = new SAXBuilder();
        Document finalDoc = null;
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            try {
                Document doc = builder.build(f);
                if (finalDoc != null) {
                    finalDoc = this.merger.merge(doc, finalDoc);
                    continue;
                }
                finalDoc = doc;
            }
            catch (JDOMException e) {
                throw new ComponentDescriptorCreatorException("Invalid input descriptor for merge: " + f, e);
            }
            catch (IOException e) {
                throw new ComponentDescriptorCreatorException("Error reading input descriptor for merge: " + f, e);
            }
            catch (MergeException e) {
                throw new ComponentDescriptorCreatorException("Error merging descriptor: " + f, e);
            }
        }
        if (finalDoc != null) {
            try {
                this.merger.writeMergedDocument(finalDoc, outputDescriptor);
            }
            catch (IOException e) {
                throw new ComponentDescriptorCreatorException("Error writing merged descriptor: " + outputDescriptor, e);
            }
        }
    }

    private void validateConfiguration(ComponentSetDescriptor componentSetDescriptor) throws ComponentDescriptorCreatorException {
        List dependencies = componentSetDescriptor.getDependencies();
        if (dependencies == null) {
            return;
        }
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            ComponentDependency dependency = (ComponentDependency)it.next();
            if (StringUtils.isEmpty((String)dependency.getGroupId())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'groupId'.");
            }
            if (StringUtils.isEmpty((String)dependency.getArtifactId())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'artifactId'.");
            }
            if (StringUtils.isEmpty((String)dependency.getVersion())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'version'.");
            }
            if (!StringUtils.isEmpty((String)dependency.getType())) continue;
            throw new ComponentDescriptorCreatorException("Missing dependency element: 'type'.");
        }
    }

    private void writeComponents(XMLWriter w, List componentDescriptors) throws ComponentDescriptorCreatorException, PlexusConfigurationException {
        w.startElement("components");
        Iterator i = componentDescriptors.iterator();
        while (i.hasNext()) {
            w.startElement("component");
            ComponentDescriptor cd = (ComponentDescriptor)i.next();
            this.element(w, "alias", cd.getAlias());
            this.element(w, "role", cd.getRole());
            this.element(w, "role-hint", cd.getRoleHint());
            this.element(w, "implementation", cd.getImplementation());
            this.element(w, "version", cd.getVersion());
            this.element(w, "instantiation-strategy", cd.getInstantiationStrategy());
            this.element(w, "lifecycle-handler", cd.getLifecycleHandler());
            this.element(w, "description", cd.getDescription());
            this.writeRequirements(w, cd.getRequirements());
            this.writeConfiguration(w, cd.getConfiguration());
            w.endElement();
        }
        w.endElement();
    }

    private void writeRequirements(XMLWriter w, List requirements) {
        if (requirements == null || requirements.size() == 0) {
            return;
        }
        w.startElement("requirements");
        Iterator j = requirements.iterator();
        while (j.hasNext()) {
            ComponentRequirement cr = (ComponentRequirement)j.next();
            w.startElement("requirement");
            this.element(w, "role", cr.getRole());
            this.element(w, "role-hint", cr.getRoleHint());
            this.element(w, "field-name", cr.getFieldName());
            w.endElement();
        }
        w.endElement();
    }

    private void writeConfiguration(XMLWriter w, PlexusConfiguration configuration) throws ComponentDescriptorCreatorException, PlexusConfigurationException {
        if (configuration == null || configuration.getChildCount() == 0) {
            return;
        }
        if (!configuration.getName().equals("configuration")) {
            throw new ComponentDescriptorCreatorException("The root node of the configuration must be 'configuration'.");
        }
        this.writePlexusConfiguration(w, configuration);
    }

    public void writeDependencies(XMLWriter w, ComponentSetDescriptor componentSetDescriptor) {
        List deps = componentSetDescriptor.getDependencies();
        if (deps == null || deps.size() == 0) {
            return;
        }
        w.startElement("dependencies");
        for (int i = 0; i < deps.size(); ++i) {
            this.writeDependencyElement((ComponentDependency)deps.get(i), w);
        }
        w.endElement();
    }

    private void writeDependencyElement(ComponentDependency dependency, XMLWriter w) {
        w.startElement("dependency");
        String groupId = dependency.getGroupId();
        this.element(w, "groupId", groupId);
        String artifactId = dependency.getArtifactId();
        this.element(w, "artifactId", artifactId);
        String type = dependency.getType();
        if (type != null) {
            this.element(w, "type", type);
        }
        String version = dependency.getVersion();
        this.element(w, "version", version);
        w.endElement();
    }

    private void writePlexusConfiguration(XMLWriter xmlWriter, PlexusConfiguration c) throws PlexusConfigurationException {
        if (c.getAttributeNames().length == 0 && c.getChildCount() == 0 && c.getValue() == null) {
            return;
        }
        xmlWriter.startElement(c.getName());
        String[] attributeNames = c.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            xmlWriter.addAttribute(attributeName, c.getAttribute(attributeName));
        }
        PlexusConfiguration[] children = c.getChildren();
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.writePlexusConfiguration(xmlWriter, children[i]);
            }
        } else {
            String value = c.getValue();
            if (value != null) {
                xmlWriter.writeText(value);
            }
        }
        xmlWriter.endElement();
    }

    private void element(XMLWriter w, String name, String value) {
        if (value == null) {
            return;
        }
        w.startElement(name);
        w.writeText(value);
        w.endElement();
    }

    private JavaClass getJavaClass(JavaSource javaSource) {
        return javaSource.getClasses()[0];
    }
}

