/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.util;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.steps.Step;
import org.apache.commons.lang.StringUtils;

public class ConversionUtil {
    public static boolean convertToBoolean(String value, boolean defaultValue) {
        if (StringUtils.isNotEmpty((String)value)) {
            return "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
        }
        return defaultValue;
    }

    public static int convertToInt(String value, int defaultValue) {
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static long convertToLong(String value, long defaultValue) {
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static float convertToFloat(String value, float defaultValue) {
        if (value != null) {
            return Float.parseFloat(value);
        }
        return defaultValue;
    }

    public static double convertToDouble(String value, double defaultValue) {
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static int convertToIntOrReject(String property, String value, Step step) throws StepExecutionException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new StepExecutionException("Can't parse \"" + value + "\" as an int for property \"" + property + "\"", step);
        }
    }
}

