/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.verify.AbstractVerifyFormStep;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class VerifySelectField
extends AbstractVerifyFormStep {
    private static final Logger LOG = Logger.getLogger(VerifySelectField.class);
    private String fText;
    private String fRegex;

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String getRegex() {
        return this.fRegex;
    }

    public void setRegex(String regex) {
        this.fRegex = regex;
    }

    protected HtmlForm findForm() {
        return FormUtil.findFormForField(this.getContext(), this.getFormName(), "select", null, this.getName(), this);
    }

    protected List findFields(HtmlForm form) {
        return form.getSelectsByName(this.getName());
    }

    protected void verifyField(HtmlElement field) throws IOException {
        HtmlSelect curSelect = (HtmlSelect)field;
        for (HtmlOption curOption : curSelect.getOptions()) {
            if (this.getText() != null && !this.verifyStrings(this.getText(), curOption.asText()) || this.getValue() != null && !this.verifyStrings(this.getValue(), curOption.getValueAttribute())) continue;
            LOG.debug((Object)("Found corresponding option " + curOption));
            if (curOption.isSelected()) {
                return;
            }
            throw new StepFailedException(this.getStepLabel() + ": " + this.buildFailMessage(this.getValue()), this);
        }
        throw new StepFailedException("Select option \"" + this.fText + " : " + this.getValue() + "\" not found for inputfield: <" + this.getName() + ">", this);
    }

    private boolean verifyStrings(String expectedValue, String actualValue) {
        return VerifySelectField.getVerifier(ConversionUtil.convertToBoolean(this.getRegex(), false)).verifyStrings(expectedValue, actualValue);
    }

    private String buildFailMessage(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("Select option <");
        sb.append("value:").append(value);
        sb.append(" / text:").append(this.getText());
        sb.append("> is not selected!");
        return sb.toString();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.isValueNull() && this.getText() == null, "Required parameter \"text\" or \"value\" not set!");
    }
}

