/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.gargoylesoftware.htmlunit.Page;
import javax.xml.xpath.XPathException;
import org.apache.log4j.Logger;

public class StoreXPath
extends BaseStoreStep {
    private static final Logger LOG = Logger.getLogger(StoreXPath.class);
    private String fXpath;
    private String fDefault;

    public String getXpath() {
        return this.fXpath;
    }

    public void setXpath(String xpath) {
        this.fXpath = xpath;
    }

    public void setDefault(String defaultValue) {
        this.fDefault = defaultValue;
    }

    public String getDefault() {
        return this.fDefault;
    }

    public void doExecute() throws XPathException {
        this.storeProperty(this.evaluateXPath());
    }

    protected String evaluateXPath() throws XPathException {
        Page currentResponse = this.getContext().getCurrentResponse();
        XPathHelper xpathHelper = this.getContext().getXPathHelper();
        String result = xpathHelper.stringValueOf(currentResponse, this.getXpath());
        if (result == null || result.length() == 0 && xpathHelper.selectFirst(currentResponse, this.getXpath()) == null) {
            if (this.getDefault() == null) {
                throw new StepFailedException("No match for xpath expression <" + this.fXpath + ">", this);
            }
            LOG.debug((Object)"No result, using default value");
            return this.getDefault();
        }
        LOG.debug((Object)("Xpath result: " + result));
        return result;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.emptyParamCheck(this.getProperty(), "property");
        this.nullParamCheck(this.getXpath(), "xpath");
    }
}

