/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyValuePdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import com.canoo.webtest.util.ConversionUtil;
import java.util.List;

public class PdfVerifyTextFieldStep
extends AbstractVerifyValuePdfStep {
    private String fName;
    private int fPage = -1;

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setPage(int page) {
        this.fPage = page;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getName(), "name");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        List fields = this.getPage() == -1 ? pdfPage.getFields(this.getName(), PDFField.TEXTBOX) : pdfPage.getFields(this.getName(), this.getPage(), PDFField.TEXTBOX);
        if (this.getExists() != null) {
            boolean exists = ConversionUtil.convertToBoolean(this.getExists(), true);
            if (exists && fields.isEmpty()) {
                throw new StepFailedException("No field found with name \"" + this.getName() + "\"");
            }
            if (!exists && !fields.isEmpty()) {
                throw new StepFailedException(fields.size() + " fields found with name \"" + this.getName() + "\"");
            }
        } else {
            if (fields.isEmpty()) {
                throw new StepFailedException("No text field named '" + this.getName() + "' found.");
            }
            boolean regex = ConversionUtil.convertToBoolean(this.getRegex(), false);
            IStringVerifier verifier = PdfVerifyTextFieldStep.getVerifier(regex);
            for (PDFField field : fields) {
                if (verifier.verifyStrings(this.getValue(), field.getValue())) continue;
                throw new StepFailedException("Wrong field value", this.getValue(), field.getValue());
            }
        }
    }
}

