/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;

public class PdfVerifyEncryptionStep
extends AbstractVerifyPdfStep {
    private boolean fEncrypted = true;
    private String fUserPassword;
    private String fOwnerPassword;

    public void setEncrypted(boolean encrypted) {
        this.fEncrypted = encrypted;
    }

    public boolean getEncrypted() {
        return this.fEncrypted;
    }

    public void setUserPassword(String userPassword) {
        this.fUserPassword = userPassword;
    }

    public String getUserPassword() {
        return this.fUserPassword;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.fOwnerPassword = ownerPassword;
    }

    public String getOwnerPassword() {
        return this.fOwnerPassword;
    }

    protected void verifyPdf(PDFPage pdfPage) {
        if (pdfPage.isEncrypted() != this.getEncrypted()) {
            String desc = "Document is " + (this.getEncrypted() ? " not" : "") + "encrypted";
            throw new StepFailedException(desc, this);
        }
        if (this.getUserPassword() != null && !pdfPage.isUserPassword(this.getUserPassword())) {
            throw new StepFailedException("Wrong user password >" + this.getUserPassword() + "<", this);
        }
        if (this.getOwnerPassword() != null && !pdfPage.isOwnerPassword(this.getOwnerPassword())) {
            throw new StepFailedException("Wrong owner password >" + this.getOwnerPassword() + "<", this);
        }
    }
}

