/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.table;

import com.canoo.ant.filter.ITableFilter;
import com.canoo.ant.table.IPropertyTable;
import java.io.File;
import java.util.Properties;

public class TableFactory {
    public static final String KEY_TABLE = "table";
    public static final String KEY_NAME = "name";
    public static final String KEY_TABLE_CLASS = "tableClass";
    public static final String KEY_CONTAINER = "container";
    public static final String KEY_FOREIGN_TABLE = "foreignTable";
    public static final String KEY_FOREIGN_NAME = "foreignName";
    public static final String KEY_FILTER_CLASS = "filterClass";
    public static final String KEY_PREFIX = "prefix";
    private static final String TABLE_PACKAGE = "com.canoo.ant.table.";
    private static final String TABLE_SUFFIX = "PropertyTable";
    private static final String FILTER_PACKAGE = "com.canoo.ant.filter.";
    private static final String FILTER_SUFFIX = "Filter";
    private static final String DEFAULT_FILTER = "FirstEquals";

    public static void initOrDefault(IPropertyTable table, ITableFilter filter, Properties colInfo, File container, String key) {
        int delimPos;
        String foreignName = colInfo.getProperty(KEY_FOREIGN_NAME, key);
        if ("".equals(foreignName)) {
            foreignName = key;
        }
        String foreignTable = null;
        if (foreignName != null && (delimPos = foreignName.indexOf(".")) > -1) {
            foreignTable = foreignName.substring(0, delimPos);
        }
        foreignTable = colInfo.getProperty(KEY_FOREIGN_TABLE, foreignTable);
        table.setPrefix(colInfo.getProperty(KEY_PREFIX, null));
        table.setContainer(container);
        table.setTable(foreignTable);
        filter.setForeignName(foreignName);
        table.setFilter(filter);
    }

    public static IPropertyTable createTable(Properties colInfo, String defaultTableClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String tableClass = colInfo.getProperty(KEY_TABLE_CLASS, defaultTableClass);
        if ("".equals(tableClass)) {
            tableClass = defaultTableClass;
        } else if (!TableFactory.isFullyQualified(tableClass)) {
            tableClass = TABLE_PACKAGE + tableClass + TABLE_SUFFIX;
        }
        return (IPropertyTable)Class.forName(tableClass).newInstance();
    }

    public static ITableFilter createFilter(Properties colInfo) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String filterClass = colInfo.getProperty(KEY_FILTER_CLASS, DEFAULT_FILTER);
        if (!TableFactory.isFullyQualified(filterClass)) {
            filterClass = FILTER_PACKAGE + filterClass + FILTER_SUFFIX;
        }
        return (ITableFilter)Class.forName(filterClass).newInstance();
    }

    private static boolean isFullyQualified(String possibleClassName) {
        return possibleClassName.indexOf(".") > -1;
    }
}

