/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.table;

import com.canoo.ant.table.APropertyTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelPropertyTable
extends APropertyTable {
    private static final Logger LOG = Logger.getLogger(ExcelPropertyTable.class);

    protected boolean hasJoinTable() {
        HSSFSheet sheet;
        try {
            sheet = this.getWorkbook().getSheet("JOIN");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read container: >" + this.getContainer() + "<", e);
        }
        return sheet != null;
    }

    private HSSFWorkbook getWorkbook() throws IOException {
        File file = this.getContainer();
        if (!file.exists()) {
            throw new FileNotFoundException("File not found >" + file.getAbsolutePath() + "< " + this.getContainer());
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("No a regular readable file: >" + file.getAbsolutePath() + "<");
        }
        POIFSFileSystem excelFile = new POIFSFileSystem((InputStream)new FileInputStream(file));
        return new HSSFWorkbook(excelFile);
    }

    protected List read(String sheetName) throws IOException {
        HSSFWorkbook workbook = this.getWorkbook();
        HSSFSheet sheet = this.getSheet(workbook, sheetName);
        int lastRowNum = sheet.getLastRowNum();
        ArrayList<String> header = new ArrayList<String>();
        HSSFRow headerRow = sheet.getRow(0);
        for (short i = 0; i < headerRow.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = headerRow.getCell(i);
            if (cell != null) {
                header.add(this.stringValueOf(workbook, sheet, headerRow, cell));
                continue;
            }
            header.add(null);
        }
        LinkedList<Properties> result = new LinkedList<Properties>();
        for (int rowNo = 1; rowNo <= lastRowNum; ++rowNo) {
            HSSFRow row = sheet.getRow(rowNo);
            if (row == null) continue;
            Properties props = new Properties();
            for (short i = 0; i < header.size(); i = (short)(i + 1)) {
                String headerName = (String)header.get(i);
                if (headerName == null) continue;
                HSSFCell cell = row.getCell(i);
                String value = this.stringValueOf(workbook, sheet, row, cell);
                this.putValue(value, headerName, props);
            }
            result.add(props);
        }
        return result;
    }

    private HSSFSheet getSheet(HSSFWorkbook workbook, String sheetName) {
        HSSFSheet sheet = sheetName == null ? workbook.getSheetAt(0) : workbook.getSheet(sheetName);
        if (null == sheet) {
            String msg = "No sheet \"" + sheetName + "\" found in file " + this.getContainer() + ". Available sheets: ";
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (i != 0) {
                    msg = msg + ", ";
                }
                msg = msg + workbook.getSheetName(i);
            }
            throw new IllegalArgumentException(msg);
        }
        return sheet;
    }

    protected void putValue(String value, Object key, Properties props) {
        props.put(key, value);
    }

    private String stringValueOf(HSSFWorkbook workbook, HSSFSheet sheet, HSSFRow row, HSSFCell cell) {
        int cellValueType;
        if (null == cell) {
            return "";
        }
        if (cell.getCellType() == 2) {
            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(sheet, workbook);
            evaluator.setCurrentRow(row);
            cellValueType = evaluator.evaluateFormulaCell(cell);
        } else {
            cellValueType = cell.getCellType();
        }
        switch (cellValueType) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                HSSFDataFormat dataFormat = workbook.createDataFormat();
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    return this.excelDateToString(dataFormat, cell);
                }
                return this.excelNumberToString(dataFormat, cell);
            }
            case 3: {
                return "";
            }
            case 4: {
                return "" + cell.getBooleanCellValue();
            }
        }
        LOG.warn((Object)("Cell Type not supported: " + cell.getCellType()));
        return "";
    }

    private String excelNumberToString(HSSFDataFormat dataFormat, HSSFCell _cell) {
        String excelFormat = dataFormat.getFormat(_cell.getCellStyle().getDataFormat());
        String javaFormat = this.excelNumberFormat2Java(excelFormat);
        LOG.debug((Object)("Excel date format >" + excelFormat + "< converted to >" + javaFormat + "< for " + _cell.getNumericCellValue()));
        String response = new DecimalFormat(javaFormat).format(_cell.getNumericCellValue());
        return response;
    }

    private String excelNumberFormat2Java(String _excelFormat) {
        if ("general".equalsIgnoreCase(_excelFormat)) {
            return "#.##";
        }
        return _excelFormat;
    }

    private String excelDateToString(HSSFDataFormat dataFormat, HSSFCell _cell) {
        String excelFormat = dataFormat.getFormat(_cell.getCellStyle().getDataFormat());
        String javaFormat = ExcelPropertyTable.excelDateFormat2Java(excelFormat);
        LOG.debug((Object)("Excel date format >" + excelFormat + "< converted to >" + javaFormat + "<"));
        Date date = HSSFDateUtil.getJavaDate((double)_cell.getNumericCellValue());
        return new SimpleDateFormat(javaFormat).format(date);
    }

    static String excelDateFormat2Java(String format) {
        format = format.replaceAll("Y", "y");
        format = format.replaceAll("DD", "dd");
        format = format.replaceAll("\\\\", "");
        format = format.replaceAll("HH:MM", "HH:mm");
        format = format.replaceAll("SS", "ss");
        format = format.replaceAll("WW", "w");
        return format;
    }
}

