/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class WeblogicMojoUtilities {
    private WeblogicMojoUtilities() {
    }

    public static void unsetWeblogicProtocolHandler() {
        if ("weblogic.utils".equals(System.getProperty("java.protocol.handler.pkgs"))) {
            System.clearProperty("java.protocol.handler.pkgs");
        }
    }

    public static String getAdminUrl(String inProtocol, String inServerName, String inServerPort) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(inProtocol).append("://");
        buffer.append(inServerName);
        buffer.append(":").append(inServerPort);
        return buffer.toString();
    }

    public static String updateArtifactName(String inName, String inProjectPackaging) {
        String newName = inName;
        if (inProjectPackaging.equalsIgnoreCase("ear")) {
            if (!inName.endsWith(".ear")) {
                newName = inName.concat(".ear");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("war")) {
            if (!inName.endsWith(".war")) {
                newName = inName.concat(".war");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("ejb")) {
            if (inName.endsWith(".ejb")) {
                newName = inName.replaceAll("\\.ejb", ".jar");
            } else if (!inName.endsWith(".jar")) {
                newName = inName.concat(".jar");
            }
        } else {
            throw new IllegalArgumentException("Unsupported project packaging " + inProjectPackaging);
        }
        return newName;
    }

    public static String getDependencies(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            return "";
        }
        Iterator iter = inArtifacts.iterator();
        StringBuffer buffer = new StringBuffer();
        if (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            buffer.append(artifact.getFile());
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        return buffer.toString();
    }

    public static File getEarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("EAR not found in artifact list.");
        }
        for (Artifact artifact : inArtifacts) {
            if (!"ear".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("EAR not found in artifact list.");
    }

    public static File getWarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("WAR not found in artifact list.");
        }
        for (Artifact artifact : inArtifacts) {
            if (!"war".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("WAR not found in artifact list.");
    }

    public static File getWarFileName(Set inArtifacts, String fileName) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("WAR not found in artifact list.");
        }
        for (Artifact artifact : inArtifacts) {
            if (!"war".equals(artifact.getType()) || !artifact.getFile().getName().contains(fileName)) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("WAR not found in artifact list.");
    }

    public static File getEjbJarFileName(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            throw new IllegalArgumentException("EJB jar not found in artifact list.");
        }
        for (Artifact artifact : inArtifacts) {
            if (!"ejb".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("EJB jar not found in artifact list.");
    }

    public static String getDependencies(Set artifacts, List pluginArtifacts, File[] files) {
        StringBuilder dependencies = new StringBuilder(WeblogicMojoUtilities.getDependencies(artifacts, pluginArtifacts));
        if (files != null) {
            for (File f : files) {
                dependencies.append(System.getProperty("path.separator"));
                dependencies.append(f.getAbsolutePath());
            }
        }
        return dependencies.toString();
    }

    public static URI[] getDependenciesAsUri(Set artifacts, List pluginArtifacts) throws MojoExecutionException {
        File[] files = WeblogicMojoUtilities.getDependenciesAsFile(artifacts, pluginArtifacts);
        URI[] uris = new URI[files.length];
        for (int i = 0; i < files.length; ++i) {
            uris[i] = files[i].toURI();
        }
        return uris;
    }

    public static File[] getDependenciesAsFile(Set artifacts, List pluginArtifacts) throws MojoExecutionException {
        if (!(artifacts != null && !artifacts.isEmpty() || pluginArtifacts != null && pluginArtifacts.size() != 0)) {
            return new File[0];
        }
        ArrayList<File> urls = new ArrayList<File>(16);
        for (Artifact artifact : pluginArtifacts) {
            urls.add(artifact.getFile());
        }
        for (Artifact artifact : artifacts) {
            urls.add(artifact.getFile());
        }
        return urls.toArray(new File[urls.size()]);
    }

    public static String getDependencies(Set artifacts, List pluginArtifacts) {
        Iterator iter;
        if (!(artifacts != null && !artifacts.isEmpty() || pluginArtifacts != null && pluginArtifacts.size() != 0)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(1024);
        Iterator pluginIter = pluginArtifacts.iterator();
        if (pluginIter.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("path.separator"));
            }
            Artifact artifact = (Artifact)pluginIter.next();
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("path.separator"));
            }
            buffer.append(artifact.getFile());
            while (pluginIter.hasNext()) {
                artifact = (Artifact)pluginIter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        if ((iter = artifacts.iterator()).hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("path.separator"));
            }
            Artifact artifact = (Artifact)iter.next();
            buffer.append(artifact.getFile());
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("path.separator"));
            }
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        return buffer.toString();
    }

    public static String toClassPath(URL[] urls) {
        StringBuilder buffer = new StringBuilder();
        String SEP = System.getProperty("path.separator");
        if (urls != null) {
            for (URL url : urls) {
                if (buffer.length() > 0) {
                    buffer.append(SEP);
                }
                buffer.append(url.getPath());
            }
        }
        return buffer.toString();
    }
}

