/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import org.codehaus.plexus.util.ReflectionUtils;
import weblogic.ant.taskdefs.j2ee.Appc;

public class AppcMojo
extends AbstractWeblogicMojo {
    private String inputArtifactPath;
    private String projectPackaging;
    private boolean verbose;
    private boolean keepGenerated;
    private String outputArtifactPath;
    private boolean forceGeneration;
    private boolean lineNumbers;
    private boolean basicClientJar;
    private String clientJarOutputDir;
    private boolean continueCompilation;

    public String getInputArtifactPath() {
        return this.inputArtifactPath;
    }

    public void setInputArtifactPath(String inInputArtifactPath) {
        this.inputArtifactPath = inInputArtifactPath;
    }

    public void execute() throws MojoExecutionException {
        super.execute();
        String classPath = WeblogicMojoUtilities.getDependencies(this.getArtifacts(), this.getPluginArtifacts());
        this.inputArtifactPath = WeblogicMojoUtilities.updateArtifactName(this.inputArtifactPath, this.projectPackaging);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic APPC processing beginning for artifact " + this.getInputArtifactPath()));
            this.getLog().info((CharSequence)(" Detailed Appc settings information " + this.toString()));
            this.getLog().info((CharSequence)("Using Classpath " + classPath));
        }
        try {
            System.setProperty("com.sun.xml.namespace.QName.useCompatibleSerialVersionUID", "1.0");
            Appc appc = new Appc();
            File source = new File(this.inputArtifactPath);
            appc.setSource(source.getAbsolutePath());
            if (this.outputArtifactPath != null) {
                File destination = new File(this.outputArtifactPath);
                appc.setOutput(destination.getAbsolutePath());
            }
            appc.setVerbose(this.verbose);
            appc.setKeepGenerated(this.keepGenerated);
            appc.setBasicClientJar(this.basicClientJar);
            Method method = ReflectionUtils.getSetter((String)"clientJarOutputDir", appc.getClass());
            if (method != null) {
                method.invoke((Object)appc, this.clientJarOutputDir);
            }
            appc.setForceGeneration(this.forceGeneration);
            appc.setLineNumbers(this.lineNumbers);
            appc.setContinueCompilation(this.continueCompilation);
            Project antProject = new Project();
            antProject.setName("appc");
            appc.setProject(antProject);
            appc.setClasspath(new Path(antProject, classPath));
            appc.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during APPC processing ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during APPC processing", ex);
        }
        finally {
            WeblogicMojoUtilities.unsetWeblogicProtocolHandler();
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic APPC processing of " + this.getInputArtifactPath() + " successful "));
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean inVerbose) {
        this.verbose = inVerbose;
    }

    public boolean isBasicClientJar() {
        return this.basicClientJar;
    }

    public void setBasicClientJar(boolean inBasicClientJar) {
        this.basicClientJar = inBasicClientJar;
    }

    public void setClientJarOutputDir(String clientJarOutputDir) {
        this.clientJarOutputDir = clientJarOutputDir;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public void setForceGeneration(boolean inForceGeneration) {
        this.forceGeneration = inForceGeneration;
    }

    public boolean isKeepGenerated() {
        return this.keepGenerated;
    }

    public void setKeepGenerated(boolean inKeepGenerated) {
        this.keepGenerated = inKeepGenerated;
    }

    public boolean isLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean inLineNumbers) {
        this.lineNumbers = inLineNumbers;
    }

    public String getOutputArtifactPath() {
        return this.outputArtifactPath;
    }

    public void setOutputArtifactPath(String inOutputArtifactPath) {
        this.outputArtifactPath = inOutputArtifactPath;
    }

    public String getProjectPackaging() {
        return this.projectPackaging;
    }

    public void setProjectPackaging(String inProjectPackaging) {
        this.projectPackaging = inProjectPackaging;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AppcMojo[");
        buffer.append("\n basicClientJar = ").append(this.basicClientJar);
        buffer.append("\n clientJarOutputDir = ").append(this.clientJarOutputDir);
        buffer.append("\n forceGeneration = ").append(this.forceGeneration);
        buffer.append("\n keepGenerated = ").append(this.keepGenerated);
        buffer.append("\n lineNumbers = ").append(this.lineNumbers);
        buffer.append("\n inputArtifactPath = ").append(this.inputArtifactPath);
        buffer.append("\n outputArtifactPath = ").append(this.outputArtifactPath);
        buffer.append("\n artifacts = ").append(this.getArtifacts());
        buffer.append("\n project Packaging = ").append(this.projectPackaging);
        buffer.append("\n verbose = ").append(this.verbose);
        buffer.append("\n continueCompilation = ").append(this.continueCompilation);
        buffer.append("]");
        return buffer.toString();
    }
}

