/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.PluginUpdatesRenderer;
import org.codehaus.mojo.versions.PluginUpdatesXmlRenderer;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="plugin-updates-report", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PluginUpdatesReport
extends AbstractVersionsReport {
    private String[] formats = new String[]{"html"};

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildPlugins() || this.haveBuildPluginManagementPlugins();
    }

    private boolean haveBuildPluginManagementPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPluginManagement() != null && this.getProject().getBuild().getPluginManagement().getPlugins() != null && !this.getProject().getBuild().getPluginManagement().getPlugins().isEmpty();
    }

    private boolean haveBuildPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPlugins() != null && !this.getProject().getBuild().getPlugins().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Plugin> pluginManagement = new TreeSet<Plugin>(new PluginComparator());
        if (this.haveBuildPluginManagementPlugins()) {
            pluginManagement.addAll(this.getProject().getBuild().getPluginManagement().getPlugins());
        }
        Set<Plugin> plugins = new TreeSet<Plugin>(new PluginComparator());
        if (this.haveBuildPlugins()) {
            plugins.addAll(this.getProject().getBuild().getPlugins());
        }
        plugins = PluginUpdatesReport.removePluginManagment(plugins, pluginManagement);
        try {
            Map<Plugin, PluginUpdatesDetails> pluginUpdates = this.getHelper().lookupPluginsUpdates(plugins, this.getAllowSnapshots());
            Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates = this.getHelper().lookupPluginsUpdates(pluginManagement, this.getAllowSnapshots());
            for (String format : this.formats) {
                if ("html".equals(format)) {
                    PluginUpdatesRenderer renderer = new PluginUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, pluginUpdates, pluginManagementUpdates);
                    renderer.render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                String outputFile = this.getProject().getBuild().getDirectory() + File.separator + this.getOutputName() + ".xml";
                PluginUpdatesXmlRenderer xmlGenerator = new PluginUpdatesXmlRenderer(pluginUpdates, pluginManagementUpdates, outputFile);
                xmlGenerator.render();
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static Set<Plugin> removePluginManagment(Set<Plugin> plugins, Set<Plugin> pluginManagement) {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin c : plugins) {
            boolean matched = false;
            for (Plugin t : pluginManagement) {
                if (!StringUtils.equals((String)t.getGroupId(), (String)c.getGroupId()) || !StringUtils.equals((String)t.getArtifactId(), (String)c.getArtifactId())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public String getOutputName() {
        return "plugin-updates-report";
    }
}

