/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.mojo.versions.utils.MiscUtils;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.xml.PluginUpdatesXmlReportRenderer;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="plugin-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PluginUpdatesReportMojo
extends AbstractVersionsReport<PluginUpdatesModel> {
    @Parameter(property="pluginUpdatesReportFormats", defaultValue="html")
    private String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectPlugins", defaultValue="false")
    protected boolean onlyProjectPlugins;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    @Inject
    protected PluginUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, artifactResolver, artifactMetadataSource, wagonManager, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildPlugins() || this.haveBuildPluginManagementPlugins();
    }

    private boolean haveBuildPluginManagementPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPluginManagement() != null && this.getProject().getBuild().getPluginManagement().getPlugins() != null && !this.getProject().getBuild().getPluginManagement().getPlugins().isEmpty();
    }

    private boolean haveBuildPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPlugins() != null && !this.getProject().getBuild().getPlugins().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Object> pluginManagement = new TreeSet<Object>(PluginComparator.INSTANCE);
        if (this.haveBuildPluginManagementPlugins()) {
            pluginManagement.addAll(this.getProject().getBuild().getPluginManagement().getPlugins());
        }
        TreeSet<Object> plugins = new TreeSet<Object>(PluginComparator.INSTANCE);
        if (this.haveBuildPlugins()) {
            plugins.addAll(this.getProject().getBuild().getPlugins());
        }
        PluginComparator comparator = PluginComparator.INSTANCE;
        if (!this.onlyProjectPlugins) {
            plugins.removeIf(plugin -> pluginManagement.stream().anyMatch(pmPlugin -> comparator.compare(plugin, pmPlugin) == 0));
        } else {
            pluginManagement.removeIf(pmPlugin -> plugins.stream().noneMatch(plugin -> comparator.compare(plugin, pmPlugin) == 0));
        }
        try {
            Map<Plugin, PluginUpdatesDetails> pluginUpdates = this.getHelper().lookupPluginsUpdates(plugins, this.getAllowSnapshots());
            Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates = this.getHelper().lookupPluginsUpdates(pluginManagement, this.getAllowSnapshots());
            if (this.onlyUpgradable) {
                pluginUpdates = MiscUtils.filter(pluginUpdates, p -> p.getVersions().length > 0);
                pluginManagementUpdates = MiscUtils.filter(pluginManagementUpdates, p -> p.getVersions().length > 0);
            }
            PluginUpdatesModel model = new PluginUpdatesModel(pluginUpdates, pluginManagementUpdates);
            for (String format : this.formats) {
                if ("html".equals(format)) {
                    this.rendererFactory.createReportRenderer(this.getOutputName(), this.getSink(), locale, model).render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                Path outputDir = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
                if (!Files.exists(outputDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(outputDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new MavenReportException("Could not create the output directory");
                    }
                }
                Path outputFile = outputDir.resolve(this.getOutputName() + ".xml");
                new PluginUpdatesXmlReportRenderer(model, outputFile).render();
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return "plugin-updates-report";
    }
}

