/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;

public class PluginUpdatesDetails {
    private final ArtifactVersions artifactVersions;
    private final Map dependencyVersions;
    private final boolean includeSnapshots;

    public PluginUpdatesDetails(ArtifactVersions artifactVersions, Map dependencyVersions, boolean includeSnapshots) {
        artifactVersions.getClass();
        dependencyVersions.getClass();
        this.artifactVersions = artifactVersions;
        this.dependencyVersions = dependencyVersions;
        this.includeSnapshots = includeSnapshots;
    }

    public ArtifactVersions getArtifactVersions() {
        return this.artifactVersions;
    }

    public Map getDependencyVersions() {
        return this.dependencyVersions;
    }

    public boolean isArtifactUpdateAvailable() {
        return this.artifactVersions.getAllUpdates(UpdateScope.ANY, this.includeSnapshots).length > 0;
    }

    public boolean isDependencyUpdateAvailable() {
        Iterator i = this.dependencyVersions.values().iterator();
        while (i.hasNext()) {
            ArtifactVersions versions = (ArtifactVersions)i.next();
            if (versions.getAllUpdates(UpdateScope.ANY, this.includeSnapshots).length <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isUpdateAvailable() {
        return this.isArtifactUpdateAvailable() || this.isDependencyUpdateAvailable();
    }
}

