/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.rpm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeFormatter {
    public static final String RPM_VERSION_IS_EXACTLY = " = ";
    public static final String RPM_VERSION_EQUAL_OR_GREATER_THAN = " >= ";
    public static final String RPM_VERSION_EQUAL_OR_LESS_THAN = " <= ";
    public static final String RPM_VERSION_GREATER_THAN = " > ";
    public static final String RPM_VERSION_LESS_THAN = " < ";

    public List<String> getRpmVersionRestrictions(String version) throws InvalidVersionSpecificationException {
        this.sanityCheckRange(version);
        ArrayList<String> rpmVersionRestrictions = new ArrayList<String>();
        HashMap<String, Boolean> rawLowerBoundsWithInclusiveness = new HashMap<String, Boolean>();
        HashMap<String, Boolean> rawUpperBoundsWithInclusiveness = new HashMap<String, Boolean>();
        String process = version;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(")");
            int index = index2 = process.indexOf("]");
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException("Unbounded range: " + version);
            }
            this.parseRange(process.substring(0, index + 1), rpmVersionRestrictions, rawLowerBoundsWithInclusiveness, rawUpperBoundsWithInclusiveness);
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        this.checkForOverlaps(rawLowerBoundsWithInclusiveness, rawUpperBoundsWithInclusiveness, version);
        if (process.length() > 0 && rpmVersionRestrictions.size() > 0) {
            throw new InvalidVersionSpecificationException("Only fully-qualified sets allowed in multiple set scenario: " + version);
        }
        return rpmVersionRestrictions;
    }

    protected void sanityCheckRange(String version) throws InvalidVersionSpecificationException {
        int endRangeCheckIdx;
        int startRangeCheckIdx = version.indexOf(91);
        if (startRangeCheckIdx < 0) {
            startRangeCheckIdx = version.indexOf(40);
        }
        if ((endRangeCheckIdx = version.indexOf(93)) < 0) {
            endRangeCheckIdx = version.indexOf(41);
        }
        if (startRangeCheckIdx > -1 && endRangeCheckIdx < 0) {
            throw new InvalidVersionSpecificationException("Version range has start but no end: " + version);
        }
        if (startRangeCheckIdx < 0 && endRangeCheckIdx > -1) {
            throw new InvalidVersionSpecificationException("Version range has end but no start: " + version);
        }
    }

    protected void checkForOverlaps(Map<String, Boolean> rawLowerBoundsWithInclusiveness, Map<String, Boolean> rawUpperBoundsWithInclusiveness, String originalVersion) throws InvalidVersionSpecificationException {
        for (String upperBound : rawUpperBoundsWithInclusiveness.keySet()) {
            for (String lowerBound : rawLowerBoundsWithInclusiveness.keySet()) {
                int comparison = lowerBound.compareTo(upperBound);
                if (comparison > 0) {
                    throw new InvalidVersionSpecificationException("Ranges overlap: " + originalVersion);
                }
                if (comparison != 0) continue;
                Boolean upperInclusive = rawUpperBoundsWithInclusiveness.get(upperBound);
                Boolean lowerInclusive = rawLowerBoundsWithInclusiveness.get(lowerBound);
                if (Boolean.FALSE.equals(upperInclusive) && Boolean.FALSE.equals(lowerInclusive)) continue;
                throw new InvalidVersionSpecificationException("Ranges overlap: " + originalVersion);
            }
        }
    }

    protected void parseRange(String range, List<String> rpmVersionRestrictions, Map<String, Boolean> rawLowerBoundsWithInclusiveness, Map<String, Boolean> rawUpperBoundsWithInclusiveness) throws InvalidVersionSpecificationException {
        boolean lowerBoundInclusive = range.startsWith("[");
        boolean upperBoundInclusive = range.endsWith("]");
        String process = range.substring(1, range.length() - 1).trim();
        int index = process.indexOf(",");
        if (index < 0) {
            if (!lowerBoundInclusive && !upperBoundInclusive) {
                return;
            }
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException("Single version must be surrounded by []: " + range);
            }
            rpmVersionRestrictions.add(RPM_VERSION_IS_EXACTLY + process);
            rawLowerBoundsWithInclusiveness.put(process, lowerBoundInclusive);
            rawUpperBoundsWithInclusiveness.put(process, upperBoundInclusive);
        } else {
            String lowerBound = process.substring(0, index).trim();
            String upperBound = process.substring(index + 1).trim();
            if (lowerBound.length() < 1) {
                lowerBound = null;
            }
            if (upperBound.length() < 1) {
                upperBound = null;
            }
            if (lowerBound != null && upperBound != null) {
                if (lowerBound.equals(upperBound)) {
                    throw new InvalidVersionSpecificationException("Range cannot have identical boundaries: " + range);
                }
                if (upperBound.compareTo(lowerBound) < 0) {
                    throw new InvalidVersionSpecificationException("Range defies version ordering: " + range);
                }
            }
            if (lowerBound != null) {
                if (lowerBoundInclusive) {
                    rpmVersionRestrictions.add(RPM_VERSION_EQUAL_OR_GREATER_THAN + lowerBound);
                } else {
                    rpmVersionRestrictions.add(RPM_VERSION_GREATER_THAN + lowerBound);
                }
                rawLowerBoundsWithInclusiveness.put(lowerBound, lowerBoundInclusive);
            }
            if (upperBound != null) {
                if (upperBoundInclusive) {
                    rpmVersionRestrictions.add(RPM_VERSION_EQUAL_OR_LESS_THAN + upperBound);
                } else {
                    rpmVersionRestrictions.add(RPM_VERSION_LESS_THAN + upperBound);
                }
                rawUpperBoundsWithInclusiveness.put(upperBound, upperBoundInclusive);
            }
        }
    }
}

