/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.rpm;

import java.io.File;
import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.SystemArchitectureDetector;
import org.codehaus.mojo.tools.rpm.RpmEvalException;
import org.codehaus.mojo.tools.rpm.RpmMediator;

public class RpmSystemArchitectureDetector
implements SystemArchitectureDetector {
    public static final String ROLE_HINT = "rpm";
    private RpmMediator rpmMediator;

    public String getSystemArchitecture() throws PlatformDetectionException {
        try {
            String myarch = this.rpmMediator.eval("_build_arch");
            File gentooFile = new File("/etc/gentoo-release");
            if (myarch.equals("i386") && gentooFile.exists()) {
                myarch = "i686";
            }
            return myarch;
        }
        catch (RpmEvalException e) {
            throw new PlatformDetectionException("Error retrieving RPM build architecture.", e);
        }
    }

    public boolean isEnabled() {
        boolean enabled = true;
        enabled = enabled && ("Linux".equalsIgnoreCase(System.getProperty("os.name")) || "Mac OS X".equals(System.getProperty("os.name")));
        enabled = enabled && (new File("/bin/rpm").exists() || new File("/usr/bin/rpm").exists() || new File("/usr/local/bin/rpm").exists() || new File("/opt/local/bin/rpm").exists());
        return enabled;
    }
}

