/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.platform;

import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.SystemDistributionDetector;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DarwinSyspropDistributionDetector
implements SystemDistributionDetector,
LogEnabled {
    public static final String ROLE_HINT = "darwin-sysprop";
    private Logger logger;

    public String getDistributionInfo() throws PlatformDetectionException {
        try {
            return "OSX release " + System.getProperty("os.version");
        }
        catch (SecurityException e) {
            throw new PlatformDetectionException("Failed to get OS version property.");
        }
    }

    public String getDistributionInfoSource() throws PlatformDetectionException {
        return "os.name";
    }

    public boolean isEnabled() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

