/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSpecFileMojo
extends AbstractMojo {
    private boolean skip;
    private String platformPostfix;
    private boolean skipPlatformPostfix;
    private Artifact projectArtifact;
    private List<Dependency> dependencies;
    private List<String> providesExclusions;
    private List<String> dependsExclusions;
    private MavenProject project;
    private String rpmName;
    private String rpmVersion;
    private File outputDirectory;
    private File topDir;
    private File destDir;
    private String prefix;
    private String release;
    private boolean rpmNoStrip;
    private File preInstallFile;
    private File postUninstallFile;
    private File preUninstallFile;
    private File postInstallFile;
    private MavenSession session;
    private RpmInfoFormatter rpmInfoFormatter;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generation of RPM spec file (per configuration).");
            return;
        }
        this.generateJar();
        HashSet<Dependency> depends = new HashSet<Dependency>();
        Set<Artifact> provides = Collections.singleton(this.projectArtifact);
        this.getLog().warn((CharSequence)"Assuming all dependencies are real RPM dependencies. Provides statement is not currently being populated.");
        for (Dependency dependency : this.dependencies) {
            depends.add(dependency);
        }
        this.processExclusions(provides, depends);
        try {
            FileReader postF;
            int c;
            FileReader preF;
            StringBuffer specBuffer = new StringBuffer();
            specBuffer.append("Summary: ").append(this.project.getName());
            specBuffer.append("\nName: ").append(this.rpmInfoFormatter.formatRpmNameWithoutVersion(this.project));
            specBuffer.append("\nVersion: ").append(this.rpmVersion);
            specBuffer.append("\nRelease: ").append(this.rpmInfoFormatter.formatProjectRelease(this.release, this.platformPostfix, this.skipPlatformPostfix));
            this.appendLicenses(this.project, specBuffer);
            if (this.skipPlatformPostfix) {
                specBuffer.append("\nBuildArch: noarch");
            }
            specBuffer.append("\nGroup: Maven 2.0");
            specBuffer.append("\nPackager: Maven 2.1");
            this.appendDependencyStatement(specBuffer, depends, this.project.getRemoteArtifactRepositories(), this.session.getLocalRepository());
            specBuffer.append("\nBuildRoot: ").append(this.destDir.getAbsolutePath());
            specBuffer.append("\nAutoReqProv: no\n");
            if (this.rpmNoStrip) {
                specBuffer.append("%define __spec_install_post %{nil}\n");
            }
            specBuffer.append("%define MavenPrefix ").append(this.prefix).append("\n");
            String description = this.project.getDescription();
            if (description == null) {
                description = "";
            }
            specBuffer.append("\n%description\n").append(description).append("\n");
            if (this.preInstallFile != null) {
                try {
                    preF = new FileReader(this.preInstallFile);
                    specBuffer.append("\n\n%pre\n");
                    while ((c = preF.read()) != -1) {
                        specBuffer.append((char)c);
                    }
                    preF.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading preInstallFile. Reason: " + e.getMessage(), (Exception)e);
                }
            }
            if (this.postInstallFile != null) {
                try {
                    postF = new FileReader(this.postInstallFile);
                    specBuffer.append("\n\n%post\n");
                    while ((c = postF.read()) != -1) {
                        specBuffer.append((char)c);
                    }
                    postF.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading postInstallFile. Reason: " + e.getMessage(), (Exception)e);
                }
            }
            if (this.postUninstallFile != null) {
                try {
                    postF = new FileReader(this.postUninstallFile);
                    specBuffer.append("\n\n%postun\n");
                    while ((c = postF.read()) != -1) {
                        specBuffer.append((char)c);
                    }
                    postF.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading postUninstallFile. Reason: " + e.getMessage(), (Exception)e);
                }
            }
            if (this.preUninstallFile != null) {
                try {
                    preF = new FileReader(this.preUninstallFile);
                    specBuffer.append("\n\n%preun\n");
                    while ((c = preF.read()) != -1) {
                        specBuffer.append((char)c);
                    }
                    preF.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading preUninstallFile. Reason: " + e.getMessage(), (Exception)e);
                }
            }
            specBuffer.append("\n%files");
            specBuffer.append("\n%defattr(-, root, root, -)");
            specBuffer.append("\n" + this.prefix + "\n");
            this.writeSpecFile(specBuffer.toString());
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to build RPM spec file. Reason: " + e.getMessage(), (Exception)e);
        }
    }

    private void generateJar() throws MojoExecutionException {
        Properties rpmProps = new Properties();
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        try {
            File rpmJarDirectory = new File(this.outputDirectory, "classes/META-INF/rpm/" + groupId + "/" + artifactId);
            if (!rpmJarDirectory.exists()) {
                rpmJarDirectory.mkdirs();
            }
            File rpmJarFile = new File(rpmJarDirectory, "rpm.properties");
            rpmProps.store(new FileOutputStream(rpmJarFile), "NAR Properties for " + groupId + "." + artifactId + "-" + version + ", a dummy file for 1.0-beta");
            this.getLog().debug((CharSequence)("Wrote JAR properties file for RPM project at " + rpmJarFile));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Cannot write JAR properties file", (Exception)ioe);
        }
    }

    private void writeSpecFile(String spec) throws MojoExecutionException {
        String specFileName;
        if (this.rpmName != null && this.rpmName.trim().length() > 0) {
            specFileName = this.rpmName + ".spec";
        } else {
            try {
                specFileName = this.rpmInfoFormatter.formatRpmName(this.project, this.rpmVersion, this.release, true, this.platformPostfix, this.skipPlatformPostfix) + ".spec";
            }
            catch (RpmFormattingException e) {
                throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        File specDir = new File(this.topDir, "SPECS");
        specDir.mkdirs();
        File specFile = new File(specDir, specFileName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(specFile);
            writer.write(spec);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write spec file: " + specFile, (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)"Failed to close spec-file writer.", (Throwable)e);
                }
            }
        }
    }

    private void processExclusions(Set<Artifact> provides, Set<Dependency> depends) {
        Dependency excluded;
        Map<String, Dependency> dependencyMap = this.getDependencyMap();
        if (this.providesExclusions != null) {
            for (String key : this.providesExclusions) {
                excluded = dependencyMap.get(key);
                provides.remove(excluded);
            }
        }
        if (this.dependsExclusions != null) {
            for (String key : this.dependsExclusions) {
                excluded = dependencyMap.get(key);
                depends.remove(excluded);
            }
        }
    }

    private Map<String, Dependency> getDependencyMap() {
        HashMap<String, Dependency> deps = new HashMap<String, Dependency>();
        for (Dependency dep : this.dependencies) {
            String key = ArtifactUtils.versionlessKey((String)dep.getGroupId(), (String)dep.getArtifactId());
            deps.put(key, dep);
        }
        return deps;
    }

    private void appendLicenses(MavenProject tmpProject, StringBuffer specBuffer) {
        List licenses = tmpProject.getLicenses();
        specBuffer.append("\nLicense: ");
        if (licenses != null && !licenses.isEmpty()) {
            Iterator it = licenses.iterator();
            while (it.hasNext()) {
                License license = (License)it.next();
                specBuffer.append(license.getName());
                if (!it.hasNext()) continue;
                specBuffer.append(", ");
            }
        } else {
            specBuffer.append("Unknown");
        }
    }

    private void appendDependencyStatement(StringBuffer specBuffer, Set<Dependency> depends, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws RpmFormattingException {
        if (!depends.isEmpty()) {
            specBuffer.append("\nRequires: ");
            Iterator<Dependency> it = depends.iterator();
            while (it.hasNext()) {
                MavenProject tmpProject;
                Dependency dependency = it.next();
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                try {
                    tmpProject = this.projectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
                }
                catch (ProjectBuildingException e) {
                    throw new RpmFormattingException("Cannot build POM for dependency: " + dependency.getManagementKey(), e);
                }
                try {
                    specBuffer.append(this.rpmInfoFormatter.formatRpmDependency(tmpProject));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new RpmFormattingException("Failed to parse dependency version range.", e);
                }
                if (!it.hasNext()) continue;
                specBuffer.append(", ");
            }
        }
    }
}

