/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;

public class Utils {
    static final String propertyFormat = "%**%";

    public static String convertToRelativePath(String path, String pathToRemove, String key) {
        path = Utils.convertToUnixStylePath(path);
        pathToRemove = Utils.convertToUnixStylePath(pathToRemove);
        if (StringUtils.isNotEmpty((String)key)) {
            String formattedKey = StringUtils.replace((String)propertyFormat, (String)"**", (String)key);
            path = StringUtils.replace((String)path, (String)pathToRemove, (String)formattedKey);
        } else {
            path = StringUtils.replace((String)path, (String)(pathToRemove + "/"), (String)"");
            path = StringUtils.replace((String)path, (String)pathToRemove, (String)".");
        }
        return path;
    }

    public static String convertToVariablePath(String path, Map pathProperties) {
        if (path != null && pathProperties != null && pathProperties.size() > 0) {
            Iterator iter = pathProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                path = Utils.convertToRelativePath(path, (String)entry.getValue(), (String)entry.getKey());
            }
        } else {
            path = Utils.convertToUnixStylePath(path);
        }
        return path;
    }

    public static List convertToPropertyPaths(List paths, Map pathProperties) {
        List result = paths;
        if (pathProperties != null && pathProperties.size() > 0) {
            Iterator iter = pathProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                result = Utils.convertToRelativePaths(result, (String)entry.getValue(), (String)entry.getKey());
            }
        }
        return result;
    }

    public static List convertToRelativePaths(List paths, String pathToRemove, String key) {
        ArrayList<String> newPaths = new ArrayList<String>(paths.size());
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            newPaths.add(Utils.convertToRelativePath((String)iter.next(), pathToRemove, key));
        }
        return newPaths;
    }

    public static String convertToUnixStylePath(String pName) {
        if (pName != null) {
            return pName.replace('\\', '/');
        }
        return null;
    }

    public static synchronized String getDynamicToString(Object obj) {
        StringBuffer buf = new StringBuffer();
        try {
            Class<?> clazz = obj.getClass();
            buf.append(clazz.getName() + ": ");
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                buf.append(" ");
                buf.append(fields[i].getName());
                buf.append("= ");
                try {
                    ((AccessibleObject)fields[i]).setAccessible(true);
                    buf.append(fields[i].get(obj));
                    buf.append(" ");
                    continue;
                }
                catch (Exception e) {
                    buf.append("Error Retrieving Value ");
                }
            }
        }
        catch (Exception e) {
            buf.append("Exception: " + e.getMessage());
        }
        return buf.toString();
    }
}

