/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.xerces.dom.DocumentImpl;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreApplication;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.core.OunceCoreProject;
import org.codehaus.mojo.ounce.core.OunceProjectBean;
import org.codehaus.mojo.ounce.core.XmlWriter;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OunceCoreXmlSerializer
implements OunceCore {
    private HashMap m_existingProjectAttributes;

    public void createApplication(String baseDir, String theName, String applicationRoot, List theProjects, Map options, Log log) throws OunceCoreException {
        Collections.sort(theProjects);
        log.info((CharSequence)"OunceCoreXmlSerializer: Writing Application parameters to xml.");
        try {
            Object xmlDoc;
            this.m_existingProjectAttributes = new HashMap();
            Element root = null;
            String filePath = baseDir + File.separator + theName + ".paf";
            File pafFile = new File(filePath);
            if (pafFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading paf: '" + filePath + "'..."));
                xmlDoc = builder.parse(pafFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Application")) continue;
                    root = (Element)node;
                    NodeList applicationChildren = node.getChildNodes();
                    for (int j = 0; j < applicationChildren.getLength(); ++j) {
                        Node child = applicationChildren.item(j);
                        String childName = child.getNodeName();
                        if (!childName.equals("Project")) continue;
                        NamedNodeMap attributes = child.getAttributes();
                        String projectPath = attributes.getNamedItem("path").getNodeValue();
                        this.m_existingProjectAttributes.put(projectPath, attributes);
                        node.removeChild(child);
                    }
                    this.insertChildProjects((Document)xmlDoc, root, theProjects);
                }
                if (root == null) {
                    throw new OunceCoreException("The existing application file '" + filePath + "' is not in a valid format and cannot be updated.");
                }
            } else {
                log.info((CharSequence)("Creating new paf: '" + filePath + "'..."));
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Application");
                root.setAttribute("name", theName);
                xmlDoc.appendChild(root);
                this.insertChildProjects((Document)xmlDoc, root, theProjects);
            }
            XmlWriter writer = new XmlWriter(true);
            writer.setWriteEmptyValues(false);
            writer.setDefaultToAttributesOnSameLine(true);
            writer.saveXmlFile(filePath, (Document)xmlDoc);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    private void insertChildProjects(Document xmlDoc, Element root, List theProjects) {
        Collections.sort(theProjects, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                OunceProjectBean project1 = (OunceProjectBean)arg0;
                OunceProjectBean project2 = (OunceProjectBean)arg1;
                String projectPath1 = project1.getPath() + File.separator + project1.name + ".ppf";
                String projectPath2 = project2.getPath() + File.separator + project2.name + ".ppf";
                return projectPath2.compareTo(projectPath1);
            }
        });
        for (int i = 0; i < theProjects.size(); ++i) {
            NodeList childNodes;
            boolean hasChildren;
            String fullPath;
            OunceProjectBean projectBean = (OunceProjectBean)theProjects.get(i);
            String projectPath = projectBean.getPath() + File.separator + projectBean.name + ".ppf";
            Element project = xmlDoc.createElementNS(null, "Project");
            NamedNodeMap existingAttribs = (NamedNodeMap)this.m_existingProjectAttributes.get(projectPath);
            if (existingAttribs != null) {
                existingAttribs.removeNamedItem("path");
                existingAttribs.removeNamedItem("language_type");
            }
            if (!(fullPath = projectPath).startsWith("./")) {
                fullPath = "./" + projectPath;
            }
            project.setAttributeNS(null, "path", fullPath);
            project.setAttributeNS(null, "language_type", "2");
            if (existingAttribs != null) {
                for (int j = 0; j < existingAttribs.getLength(); ++j) {
                    Node node = existingAttribs.item(j);
                    String name = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    project.setAttributeNS(null, name, nodeValue);
                }
            }
            boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
            if (hasChildren) {
                Node child = childNodes.item(0);
                root.insertBefore(project, child);
                continue;
            }
            root.appendChild(project);
        }
    }

    public void createProject(String baseDir, String theName, String projectRoot, List theSourceRoots, String theWebRoot, String theClassPath, String theJdkName, String compilerOptions, String packaging, Map options, Log log) throws OunceCoreException {
        log.info((CharSequence)"OunceCoreXmlSerializer: Writing Project parameters to xml.");
        Properties projectProperties = new Properties();
        projectProperties.setProperty("name", theName);
        projectProperties.setProperty("language_type", "2");
        projectProperties.setProperty("default_configuration_name", "Configuration 1");
        if (options != null) {
            Set keys = options.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)options.get(key);
                projectProperties.setProperty(key, value);
            }
        }
        if (!StringUtils.isEmpty((String)theWebRoot) && !StringUtils.isEmpty((String)packaging) && packaging.equals("war")) {
            projectProperties.setProperty("web_context_root_path", theWebRoot.trim());
        } else {
            theWebRoot = null;
        }
        if (!StringUtils.isEmpty((String)compilerOptions)) {
            projectProperties.setProperty("compiler_options", compilerOptions);
        }
        try {
            Object xmlDoc;
            HashMap<String, NamedNodeMap> existingConfigurationAttribs = new HashMap<String, NamedNodeMap>();
            HashMap<String, NamedNodeMap> existingSourceAttribs = new HashMap<String, NamedNodeMap>();
            ArrayList<Node> excludedSources = new ArrayList<Node>();
            Element root = null;
            String filePath = baseDir + File.separator + theName + ".ppf";
            File ppfFile = new File(filePath);
            if (ppfFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading ppf: '" + filePath + "'..."));
                xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    root = (Element)node;
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        NamedNodeMap attributes = child.getAttributes();
                        if (childName.equals("Configuration")) {
                            String configurationName = attributes.getNamedItem("name").getNodeValue();
                            existingConfigurationAttribs.put(configurationName, attributes);
                            node.removeChild(child);
                            continue;
                        }
                        if (!childName.equals("Source")) continue;
                        String sourcePath = attributes.getNamedItem("path").getNodeValue();
                        String excludedStr = attributes.getNamedItem("exclude").getNodeValue();
                        if (excludedStr.equals("true")) {
                            excludedSources.add(child);
                        }
                        existingSourceAttribs.put(sourcePath, attributes);
                        node.removeChild(child);
                    }
                }
                if (root == null) {
                    throw new OunceCoreException("The existing project file '" + filePath + "' is not in a valid format and cannot be updated.");
                }
            } else {
                log.info((CharSequence)"Creating new Document...");
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Project");
                xmlDoc.appendChild(root);
            }
            Enumeration<?> propertyNames = projectProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object propertyNameObject = propertyNames.nextElement();
                String name = (String)propertyNameObject;
                String value = projectProperties.getProperty(name);
                root.setAttribute(name, value);
            }
            this.insertSources((Document)xmlDoc, root, baseDir, theSourceRoots, theWebRoot, existingSourceAttribs, excludedSources);
            this.insertConfigurations((Document)xmlDoc, root, theClassPath, theJdkName, existingConfigurationAttribs);
            XmlWriter writer = new XmlWriter(true);
            writer.setWriteEmptyValues(false);
            writer.setDefaultToAttributesOnSameLine(true);
            writer.saveXmlFile(filePath, (Document)xmlDoc);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    private void insertConfigurations(Document xmlDoc, Element root, String theClassPath, String theJdkName, HashMap existingConfigurationAttribs) {
        NodeList childNodes;
        boolean hasChildren;
        Properties configProperties = new Properties();
        String configurationName = "Configuration 1";
        configProperties.setProperty("name", configurationName);
        configProperties.setProperty("class_path", theClassPath);
        if (!StringUtils.isEmpty((String)theJdkName)) {
            configProperties.setProperty("jdk_name", theJdkName.trim());
        }
        Element configuration = xmlDoc.createElementNS(null, "Configuration");
        NamedNodeMap existingConfigAttribs = (NamedNodeMap)existingConfigurationAttribs.get(configurationName);
        Enumeration<?> propertyNames = configProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object propertyNameObject = propertyNames.nextElement();
            String name = (String)propertyNameObject;
            String value = configProperties.getProperty(name);
            configuration.setAttributeNS(null, name, value);
            if (existingConfigAttribs == null) continue;
            existingConfigAttribs.removeNamedItem(name);
        }
        if (existingConfigAttribs != null) {
            for (int j = 0; j < existingConfigAttribs.getLength(); ++j) {
                Node node = existingConfigAttribs.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                configuration.setAttributeNS(null, name, value);
            }
        }
        boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
        if (hasChildren) {
            Node child = childNodes.item(0);
            root.insertBefore(configuration, child);
        } else {
            root.appendChild(configuration);
        }
    }

    private void insertSources(Document xmlDoc, Element root, String baseDir, List theSourceRoots, String webRoot, HashMap existingSourceAttribs, ArrayList excludedSources) {
        int i;
        Collections.sort(theSourceRoots, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String root1 = (String)arg0;
                String root2 = (String)arg1;
                return root2.compareTo(root1);
            }
        });
        for (i = 0; i < theSourceRoots.size(); ++i) {
            String sourceRoot = (String)theSourceRoots.get(i);
            if (this.pathAlreadyInNodeList(excludedSources, sourceRoot)) continue;
            this.addSourceElement(xmlDoc, root, sourceRoot, "false", false, existingSourceAttribs);
        }
        for (i = 0; i < excludedSources.size(); ++i) {
            boolean hasChildren;
            Node node = (Node)excludedSources.get(i);
            NamedNodeMap attributes = node.getAttributes();
            String path = attributes.getNamedItem("path").getNodeValue();
            if (!new File(baseDir + File.separator + path).exists()) continue;
            NodeList childNodes = root.getChildNodes();
            boolean bl = hasChildren = childNodes.getLength() > 0;
            if (hasChildren) {
                Node child = childNodes.item(0);
                root.insertBefore(node, child);
                continue;
            }
            root.appendChild(node);
        }
        if (webRoot != null) {
            this.addSourceElement(xmlDoc, root, webRoot, "true", true, existingSourceAttribs);
        }
    }

    private void addSourceElement(Document xmlDoc, Element root, String sourceRoot, String defaultWeb, boolean forceWeb, HashMap existingSourceAttribs) {
        NodeList childNodes;
        boolean hasChildren;
        String fullSourceRoot;
        Element source = xmlDoc.createElementNS(null, "Source");
        NamedNodeMap existingAttribs = (NamedNodeMap)existingSourceAttribs.get(sourceRoot);
        if (existingAttribs != null) {
            existingAttribs.removeNamedItem("path");
        }
        if (!(fullSourceRoot = sourceRoot).startsWith("./")) {
            fullSourceRoot = "./" + sourceRoot;
        }
        source.setAttributeNS(null, "path", fullSourceRoot);
        if (existingAttribs == null || existingAttribs.getNamedItem("exclude") == null) {
            source.setAttributeNS(null, "exclude", "false");
        }
        if (forceWeb) {
            if (existingAttribs != null) {
                existingAttribs.removeNamedItem("web");
            }
            source.setAttributeNS(null, "web", defaultWeb);
        } else if (existingAttribs == null || existingAttribs.getNamedItem("web") == null) {
            source.setAttributeNS(null, "web", defaultWeb);
        }
        if (existingAttribs != null) {
            for (int j = 0; j < existingAttribs.getLength(); ++j) {
                Node node = existingAttribs.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                source.setAttributeNS(null, name, value);
            }
        }
        boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
        if (hasChildren) {
            Node child = childNodes.item(0);
            root.insertBefore(source, child);
        } else {
            root.appendChild(source);
        }
    }

    private boolean pathAlreadyInNodeList(ArrayList list, String relPath) {
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            NamedNodeMap attributes = node.getAttributes();
            String path = attributes.getNamedItem("path").getNodeValue();
            if (!relPath.startsWith("./")) {
                relPath = "./" + relPath;
            }
            if (!relPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    public OunceCoreApplication readApplication(String path, Log log) throws OunceCoreException {
        block6: {
            try {
                File pafFile = new File(path);
                if (pafFile.exists()) {
                    String parentDir = pafFile.getParent();
                    String applicationName = null;
                    String applicationRoot = null;
                    ArrayList<OunceCoreProject> projects = new ArrayList<OunceCoreProject>();
                    HashMap options = new HashMap();
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    if (log != null) {
                        log.info((CharSequence)("Reading paf: '" + path + "'..."));
                    }
                    Document xmlDoc = builder.parse(pafFile);
                    NodeList nodes = xmlDoc.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        String name = node.getNodeName();
                        if (!name.equals("Application")) continue;
                        NamedNodeMap applicationAttribs = node.getAttributes();
                        applicationName = applicationAttribs.getNamedItem("name").getNodeValue();
                        NodeList applicationChildren = node.getChildNodes();
                        for (int j = 0; j < applicationChildren.getLength(); ++j) {
                            Node child = applicationChildren.item(j);
                            String childName = child.getNodeName();
                            if (!childName.equals("Project")) continue;
                            String projectPath = parentDir + File.separator + child.getAttributes().getNamedItem("path").getNodeValue();
                            OunceCoreProject project = this.readProject(projectPath, log);
                            projects.add(project);
                        }
                    }
                    OunceCoreApplication application = new OunceCoreApplication(applicationName, applicationRoot, projects, options);
                    return application;
                }
            }
            catch (Exception ex) {
                if (log == null) break block6;
                log.error((Throwable)ex);
            }
        }
        return null;
    }

    public OunceCoreProject readProject(String path, Log log) throws OunceCoreException {
        try {
            File ppfFile = new File(path);
            if (ppfFile.exists()) {
                String projectRoot = ppfFile.getParent();
                String projectName = null;
                String jdkName = null;
                String classPath = null;
                String webRoot = null;
                String optionsStr = null;
                ArrayList<String> sourceRoots = new ArrayList<String>();
                HashMap<String, String> options = new HashMap<String, String>();
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (log != null) {
                    log.info((CharSequence)("Reading ppf: '" + path + "'..."));
                }
                Document xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    NamedNodeMap projectAttribs = node.getAttributes();
                    for (int j = 0; j < projectAttribs.getLength(); ++j) {
                        Node attribNode = projectAttribs.item(j);
                        String nodeName = attribNode.getNodeName();
                        String nodeValue = attribNode.getNodeValue();
                        if (nodeName.equals("name") || nodeName.equals("web_context_root_path")) continue;
                        options.put(nodeName, nodeValue);
                    }
                    if (projectAttribs.getNamedItem("web_context_root_path") != null) {
                        webRoot = projectAttribs.getNamedItem("web_context_root_path").getNodeValue();
                    }
                    projectName = projectAttribs.getNamedItem("name").getNodeValue();
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        NamedNodeMap attribs = child.getAttributes();
                        if (childName.equals("Configuration")) {
                            if (attribs.getNamedItem("jdk_name") != null) {
                                jdkName = attribs.getNamedItem("jdk_name").getNodeValue();
                            }
                            if (attribs.getNamedItem("class_path") != null) {
                                classPath = attribs.getNamedItem("class_path").getNodeValue();
                            }
                            if (attribs.getNamedItem("compiler_options") == null) continue;
                            optionsStr = attribs.getNamedItem("compiler_options").getNodeValue();
                            continue;
                        }
                        if (!childName.equals("Source")) continue;
                        String sourcePath = attribs.getNamedItem("path").getNodeValue();
                        String webStr = attribs.getNamedItem("web").getNodeValue();
                        if (webStr != null && (webStr == null || webStr.equals("true"))) continue;
                        sourceRoots.add(sourcePath);
                    }
                }
                String packaging = null;
                if (webRoot != null) {
                    packaging = "war";
                }
                OunceCoreProject project = new OunceCoreProject(projectName, projectRoot, sourceRoots, webRoot, classPath, jdkName, packaging, optionsStr, options);
                return project;
            }
            throw new OunceCoreException("The file '" + ppfFile.getPath() + "' does not exist.");
        }
        catch (Exception ex) {
            if (log != null) {
                log.error((Throwable)ex);
            }
            return null;
        }
    }

    public void scan(String applicationFile, String assessmentName, String assessmentOutput, String caller, String reportType, String reportOutputType, String reportOutputLocation, boolean publish, Map ounceOptions, String installDir, boolean wait, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        String existingAssessment = null;
        int includeSrcBefore = -1;
        int includeSrcAfter = -1;
        if (ounceOptions != null) {
            if (ounceOptions.get("existingAssessmentFile") != null) {
                existingAssessment = (String)ounceOptions.get("existingAssessmentFile");
            }
            if (ounceOptions.get("includeSrcBefore") != null) {
                includeSrcBefore = (Integer)ounceOptions.get("includeSrcBefore");
            }
            if (ounceOptions.get("includeSrcAfter") != null) {
                includeSrcAfter = (Integer)ounceOptions.get("includeSrcAfter");
            }
        }
        try {
            if (existingAssessment == null) {
                command = command + " scanapplication";
                if (!StringUtils.isEmpty((String)applicationFile)) {
                    command = command + " -application_file \"" + applicationFile + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentName)) {
                    command = command + " -name \"" + assessmentName + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentOutput)) {
                    command = command + " -save \"" + assessmentOutput + "\"";
                }
                if (!StringUtils.isEmpty((String)reportType)) {
                    command = command + " -report \"" + reportType + "\" \"" + reportOutputType + "\" " + "\"" + reportOutputLocation + "\"";
                }
                if (publish) {
                    command = command + " -publish";
                }
            } else {
                command = command + " generatereport -assessment \"" + existingAssessment + "\"";
                if (!StringUtils.isEmpty((String)reportType)) {
                    command = command + " -type \"" + reportType + "\" -output \"" + reportOutputType + "\" -file \"" + reportOutputLocation + "\"";
                }
            }
            if (!StringUtils.isEmpty((String)caller)) {
                command = command + " -caller \"" + caller + "\"";
            }
            if (includeSrcBefore != -1) {
                command = command + " -includeSrcBefore " + includeSrcBefore;
            }
            if (includeSrcAfter != -1) {
                command = command + " -includeSrcAfter " + includeSrcAfter;
            }
            System.out.println(command);
            int requestId = this.executeCommand(command, log);
            System.out.println("requestId: " + requestId);
            if (wait) {
                command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
                command = command + " wait -requestid " + requestId;
                System.out.println(command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            throw new OunceCoreException(ex);
        }
    }

    public void createPathVariables(Map pathVariableMap, String installDir, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        try {
            command = command + " setvars";
            if (pathVariableMap != null) {
                Set keys = pathVariableMap.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)pathVariableMap.get(key);
                    command = command + " -" + key + " " + value;
                }
                System.out.println(command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private int executeCommand(String command, Log log) throws IOException, InterruptedException {
        String line;
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            if (log != null) {
                log.info((CharSequence)("ounceauto: " + line));
                continue;
            }
            System.out.println("ounceauto: " + line);
        }
        input.close();
        return p.waitFor();
    }
}

