/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.codehaus.mojo.jboss.JBossServerUtil;

public abstract class AbstractJBossServerMojo
extends AbstractMojo {
    protected File jbossHome;
    protected String serverName;
    private WagonManager wagonManager;
    private String serverId;

    protected void checkConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Using JBOSS_HOME: " + this.jbossHome));
        if (this.jbossHome == null) {
            throw new MojoExecutionException("Neither environment JBOSS_HOME nor the jbossHome parameter is set!");
        }
        if (!this.jbossHome.isDirectory()) {
            throw new MojoExecutionException("Configured JBoss home directory does not exist: " + this.jbossHome);
        }
    }

    protected void launch(String commandName, String options) throws MojoExecutionException {
        this.checkConfig();
        String osName = System.getProperty("os.name");
        String commandExt = osName.startsWith("Windows") ? ".bat" : ".sh";
        String jbossCommand = commandName + commandExt;
        File jbossHomeBin = new File(this.jbossHome, "bin");
        File jbossCommandFile = new File(jbossHomeBin, jbossCommand);
        if (!jbossCommandFile.isFile()) {
            throw new MojoExecutionException("JBoss command '" + commandName + "' at " + jbossCommandFile.toString() + " is not an executable program");
        }
        this.getLog().debug((CharSequence)("Executing JBoss command: " + jbossCommandFile + " " + options));
        try {
            if (osName.startsWith("Windows")) {
                this.launchWindowsBatch(jbossCommandFile, options);
            } else {
                this.launchUnixScript(jbossCommandFile, options);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute command: " + jbossCommandFile.toString(), (Exception)e);
        }
    }

    protected void launchWindowsBatch(File commandFile, String options) throws IOException {
        String[] commandWithOptions = new String[]{"cmd.exe", "/C", "cd /D " + this.jbossHome + "\\bin & set JBOSS_HOME=\"" + this.jbossHome + "\"&" + commandFile.getName() + " " + options};
        Process proc = Runtime.getRuntime().exec(commandWithOptions);
        JBossServerUtil.dump(proc.getInputStream());
        JBossServerUtil.dump(proc.getErrorStream());
    }

    protected void launchUnixScript(File commandFile, String options) throws IOException {
        String[] optionsArray = new String[]{};
        if (options != null) {
            optionsArray = options.trim().split("\\s+");
        }
        String[] commandWithOptions = new String[optionsArray.length + 1];
        commandWithOptions[0] = commandFile.getAbsolutePath();
        for (int i = 0; i < optionsArray.length; ++i) {
            commandWithOptions[i + 1] = optionsArray[i];
        }
        String[] env = new String[]{"JBOSS_HOME=" + this.jbossHome.getAbsolutePath()};
        Process proc = Runtime.getRuntime().exec(commandWithOptions, env, commandFile.getParentFile());
        JBossServerUtil.dump(proc.getInputStream());
        JBossServerUtil.dump(proc.getErrorStream());
    }

    public String getUsername() throws MojoExecutionException {
        if (this.serverId != null) {
            AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.serverId);
            if (info == null) {
                throw new MojoExecutionException("Server not defined in settings.xml: " + this.serverId);
            }
            return info.getUserName();
        }
        return null;
    }

    public String getPassword() throws MojoExecutionException {
        if (this.serverId != null) {
            AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.serverId);
            if (info == null) {
                throw new MojoExecutionException("Server not defined in settings.xml: " + this.serverId);
            }
            return info.getPassword();
        }
        return null;
    }
}

