/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:javancss-maven-plugin:2.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "JavaNCSS Maven Plugin", 0);
        this.append(sb, "Maven2 plugin generating NCSS and CCN code metrics.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "javancss:check", 0);
            this.append(sb, "Check the build if for any Method with a ccn greater than a limit in the source code. Fails the build if told so.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ccnLimit (Default: 10)", 2);
                this.append(sb, "CCN Limit, any code with a ccn greater than this number will generate a violation", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnViolation (Default: true)", 2);
                this.append(sb, "Whether to fail the build if the validation check fails.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ncssLimit (Default: 100)", 2);
                this.append(sb, "ncss Limit, any code with a ncss greater than this number will generate a violation", 3);
                this.append(sb, "", 0);
                this.append(sb, "tempFileName (Default: javancss-raw-report.xml)", 2);
                this.append(sb, "Name of the file holding the xml file generated by JavaNCSS", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the XML report will be generated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "javancss:help", 0);
            this.append(sb, "Display help information on javancss-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0javancss:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "javancss:report", 0);
            this.append(sb, "Generates a JavaNCSS report based on this module's source code.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of ant-style patterns used to specify the java sources that should be excluded when running JavaNCSS. If this is not specified, no files in the project source directories are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of ant-style patterns used to specify the java sources that should be included when running JavaNCSS. If this is not specified, all .java files in the project source directories are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineThreshold (Default: 30)", 2);
                this.append(sb, "Specifies the maximum number of lines to take into account into the reports.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Link the violation line numbers to the source xref. Defaults to true and will link automatically if jxr plugin is being used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the encoding of the source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tempFileName (Default: javancss-raw-report.xml)", 2);
                this.append(sb, "Specified the name of the temporary file generated by JavaNCSS prior report generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the XML report will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.build.directory}/site/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

