/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.IdljTranslator;
import org.codehaus.mojo.idlj.JacorbTranslator;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractIDLJMojo
extends AbstractMojo {
    private List sources;
    private boolean debug;
    private boolean failOnError;
    private MavenProject project;
    private int staleMillis;
    private MavenProjectHelper projectHelper;
    private File timestampDirectory;
    private String compiler;

    protected abstract File getSourceDirectory() throws MojoExecutionException;

    protected abstract File[] getIncludeDirs();

    protected abstract File getOutputDirectory() throws MojoExecutionException;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException {
        void var1_1;
        AbstractTranslator translator;
        if (!this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        if (!this.getOutputDirectory().canWrite()) {
            throw new MojoExecutionException("Cannot write in : " + this.getOutputDirectory());
        }
        this.addCompileSourceRoot();
        if (!this.timestampDirectory.exists()) {
            this.timestampDirectory.mkdirs();
        }
        if (this.compiler == null) {
            translator = new IdljTranslator();
        } else if (this.compiler.equals("idlj")) {
            translator = new IdljTranslator();
        } else if (this.compiler.equals("jacorb")) {
            translator = new JacorbTranslator();
        } else {
            throw new MojoExecutionException("Compiler not supported: " + this.compiler);
        }
        var1_1.setDebug(this.debug);
        var1_1.setFailOnError(this.failOnError);
        var1_1.setLog(this.getLog());
        if (this.sources != null) {
            Iterator it = this.sources.iterator();
            while (it.hasNext()) {
                Source source = (Source)it.next();
                this.processSource(source, (CompilerTranslator)var1_1);
            }
        } else {
            Source defaultSourceConfiguration = new Source();
            this.processSource(defaultSourceConfiguration, (CompilerTranslator)var1_1);
        }
    }

    private void processSource(Source source, CompilerTranslator translator) throws MojoExecutionException {
        Set staleGrammars = this.computeStaleGrammars(source);
        if (staleGrammars.size() > 0) {
            this.getLog().info((CharSequence)("Processing " + staleGrammars.size() + " grammar files to " + this.getOutputDirectory()));
        } else {
            this.getLog().info((CharSequence)"Nothing to compile - all idl files are up to date");
        }
        Iterator it = staleGrammars.iterator();
        while (it.hasNext()) {
            File idlFile = (File)it.next();
            this.getLog().debug((CharSequence)("Processing: " + idlFile.toString()));
            translator.invokeCompiler(this.getSourceDirectory().getAbsolutePath(), this.getIncludeDirs(), this.getOutputDirectory().getAbsolutePath(), idlFile.toString(), source);
            try {
                URI relativeURI = this.getSourceDirectory().toURI().relativize(idlFile.toURI());
                File timestampFile = new File(this.timestampDirectory.toURI().resolve(relativeURI));
                FileUtils.copyFile((File)idlFile, (File)timestampFile);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to copy IDL file to output directory: " + e));
            }
        }
    }

    private Set computeStaleGrammars(Source source) throws MojoExecutionException {
        HashSet<String> includes = source.getIncludes();
        this.getLog().debug((CharSequence)("includes : " + includes));
        if (includes == null) {
            includes = new HashSet<String>();
            includes.add("**/*.idl");
        }
        HashSet excludes = source.getExcludes();
        this.getLog().debug((CharSequence)("excludes : " + excludes));
        if (excludes == null) {
            excludes = new HashSet();
        }
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, includes, excludes);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".idl", ".idl"));
        HashSet staleSources = new HashSet();
        File sourceDir = this.getSourceDirectory();
        this.getLog().debug((CharSequence)("sourceDir : " + sourceDir));
        try {
            if (sourceDir.exists() && sourceDir.isDirectory()) {
                staleSources.addAll(scanner.getIncludedSources(sourceDir, this.timestampDirectory));
            } else {
                this.getLog().debug((CharSequence)"sourceDir isn't a directory");
            }
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale CORBA IDL files to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }

    protected abstract void addCompileSourceRoot() throws MojoExecutionException;

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }
}

