/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.fitnesse.FileUtil;
import org.codehaus.mojo.fitnesse.Fitnesse;
import org.codehaus.mojo.fitnesse.FitnesseAbstractMojo;
import org.codehaus.mojo.fitnesse.FitnessePage;
import org.codehaus.mojo.fitnesse.FitnesseReportMojo;

public class FitnesseRemoteRunnerMojo
extends FitnesseAbstractMojo {
    public static final String START_REPORT_TAG_KO = "document.getElementById(\"test-summary\").className = \"fail\"";
    public static final String START_REPORT_TAG_KO2 = "document.getElementById(\"test-summary\").className = \"error\"";
    public static final String START_REPORT_TAG_OK = "document.getElementById(\"test-summary\").className = \"pass\"";

    public void execute() throws MojoExecutionException, MojoFailureException {
        new File(this.workingDir).mkdirs();
        this.checkConfiguration();
        try {
            FitnesseReportMojo.copyAllResources(new File(this.workingDir), this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Unable to copy resources", e.getCause());
        }
        this.getLog().info((CharSequence)("Found " + this.getFitnesseSize() + " Fitnesse configuration."));
        MojoFailureException tLastFailure = null;
        for (int i = 0; i < this.getFitnesseSize(); ++i) {
            try {
                this.callFitnesse(i);
                continue;
            }
            catch (MojoFailureException e) {
                tLastFailure = e;
            }
        }
        if (tLastFailure != null) {
            throw tLastFailure;
        }
    }

    void callFitnesse(int pServerConfPosition) throws MojoFailureException, MojoExecutionException {
        File tOutput;
        Fitnesse tServer = this.getFitnesse(pServerConfPosition);
        File tResultFile = new File(this.getFinalFileName(tServer));
        if (tResultFile.exists()) {
            tResultFile.delete();
        }
        if ((tOutput = new File(this.getOutputFileName(tServer))).exists()) {
            tOutput.delete();
        }
        try {
            FileOutputStream tOutputStream = new FileOutputStream(tOutput);
            tResultFile.createNewFile();
            ByteArrayOutputStream tOut = new ByteArrayOutputStream();
            this.getRemoteResource("http://" + tServer.getHostName() + ":" + tServer.getPort() + "/" + tServer.getPageName() + "?" + tServer.getType(), tOut, tServer);
            String tOutAsString = tOut.toString();
            FitnessePage tFitnessePage = new FitnessePage(tOutAsString);
            this.transformHtml(new ByteArrayInputStream(tOut.toByteArray()), new FileWriter(tResultFile), this.getOutputUrl(tServer), tFitnessePage.getStatus());
            this.getRemoteResource("http://" + tServer.getHostName() + ":" + tServer.getPort() + "/ErrorLogs." + tServer.getPageName(), tOutputStream, tServer);
            this.transformOutputPage(this.getOutputFileName(tServer));
            this.checkFailure(tOutAsString, tResultFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create File [" + tResultFile.getAbsolutePath() + "].", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transformOutputPage(String pFinalOutputName) throws IOException, MojoExecutionException {
        int tEndIndex;
        String tSrcAsString = FileUtil.getString(new File(pFinalOutputName));
        tSrcAsString = tSrcAsString.replaceAll("/files/css/", "");
        tSrcAsString = tSrcAsString.replaceAll("fitnesse.css", "fitnesse_base.css");
        tSrcAsString = tSrcAsString.replaceAll("/files/javascript/", "");
        StringBuffer tFinal = new StringBuffer();
        int tStartIndex = tSrcAsString.indexOf("<div class=\"sidebar\">");
        if (tStartIndex != -1) {
            tEndIndex = tSrcAsString.indexOf("<div class=\"mainbar\">");
            tFinal.append(tSrcAsString.substring(0, tStartIndex));
            tFinal.append(tSrcAsString.substring(tEndIndex, tSrcAsString.length()));
            tSrcAsString = tFinal.toString();
        }
        if ((tStartIndex = tSrcAsString.indexOf("<div class=\"header\">")) != -1) {
            tFinal = new StringBuffer();
            tEndIndex = tSrcAsString.indexOf("</div>\r\n") + "</div>\r\n".length();
            tFinal.append(tSrcAsString.substring(0, tStartIndex));
            tFinal.append(tSrcAsString.substring(tEndIndex, tSrcAsString.length()));
            tSrcAsString = tFinal.toString();
        }
        if (!new File(pFinalOutputName).delete()) {
            throw new MojoExecutionException("Unable to delete output file");
        }
        FileWriter tWriter = null;
        try {
            tWriter = new FileWriter(pFinalOutputName);
            tWriter.write(tSrcAsString);
        }
        finally {
            if (tWriter != null) {
                tWriter.close();
            }
        }
    }

    void checkFailure(String pFileContent, String pFileName) throws MojoFailureException, MojoExecutionException {
        if (this.isFailOnError()) {
            int tIndexOk = pFileContent.indexOf(START_REPORT_TAG_OK);
            int tIndexKo = pFileContent.indexOf(START_REPORT_TAG_KO);
            int tIndexKo2 = pFileContent.indexOf(START_REPORT_TAG_KO2);
            if (tIndexOk == -1) {
                if (tIndexKo == -1 && tIndexKo2 == -1) {
                    throw new MojoExecutionException("Unable to find failure result into FitNesse page, resultFile=[" + pFileName + "].");
                }
                throw new MojoFailureException("FitNesse page fail, resultFile=[" + pFileName + "].");
            }
            if (tIndexKo != -1 || tIndexKo2 != -1) {
                throw new MojoExecutionException("Find both success and fail result into FitNesse page , resultFile=[" + pFileName + "].");
            }
        }
    }

    void getRemoteResource(String pUrl, OutputStream pOutStream, Fitnesse pServer) throws MojoExecutionException {
        try {
            GetMethod tMethod;
            int tStatusCode;
            HttpClient tClient = new HttpClient();
            this.getLog().info((CharSequence)("Request resources from [" + pUrl + "]"));
            if (pServer.getServerId() != null) {
                tClient.getParams().setAuthenticationPreemptive(true);
                UsernamePasswordCredentials defaultcreds = this.getCredential(pServer.getServerId());
                AuthScope tAuthScope = new AuthScope(pServer.getHostName(), pServer.getPort(), AuthScope.ANY_REALM);
                tClient.getState().setCredentials(tAuthScope, (Credentials)defaultcreds);
                this.getLog().info((CharSequence)"Use credential for remote connection");
            }
            if ((tStatusCode = tClient.executeMethod((HttpMethod)(tMethod = new GetMethod(pUrl)))) != 200) {
                throw new MojoExecutionException("Bad response code from resource [" + pUrl + "], return code=[" + tStatusCode + "]");
            }
            InputStream tResponseStream = tMethod.getResponseBodyAsStream();
            byte[] tbytes = new byte[512];
            int tReadBytes = tResponseStream.read(tbytes);
            while (tReadBytes >= 0) {
                pOutStream.write(tbytes, 0, tReadBytes);
                tReadBytes = tResponseStream.read(tbytes);
            }
            pOutStream.flush();
            tMethod.releaseConnection();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read FitNesse server response.", (Exception)e);
        }
        finally {
            try {
                pOutStream.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to close Stream.");
            }
        }
    }

    public void setWorkingDir(String pWorkingDir) {
        this.workingDir = pWorkingDir;
    }

    String getOutputFileName(Fitnesse pServer) {
        return this.getResultFileName(pServer, "_output", "html");
    }

    String getOutputUrl(Fitnesse pServer) {
        return "fitnesseResult_" + pServer.getHostName() + "_" + pServer.getPageName() + "_output.html";
    }
}

