/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.codehaus.mojo.fitnesse.FileUtil;
import org.codehaus.mojo.fitnesse.Fitnesse;

public abstract class FitnesseAbstractMojo
extends AbstractMojo {
    public static final String FITNESSE_RESULT_PREFIX = "fitnesseResult";
    public static final String OUTPUT_EXTENSION = "_output";
    private List fitnesses;
    private boolean failOnError;
    private String dateFormat;
    private List servers = new ArrayList();
    protected String workingDir;
    String cmdFitnessePage;
    String cmdFitnesseHostName;
    int cmdFitnessePort = -1;

    void checkConfiguration() throws MojoExecutionException {
        this.changeConfigWithCmdLineParameters();
        if (this.fitnesses == null || this.fitnesses.size() == 0) {
            String errorMessage = "Your should configure at least one Fitnesse server. Check your maven-fitnesse-plugin configuration.";
            this.getLog().error((CharSequence)errorMessage);
            throw new MojoExecutionException(errorMessage);
        }
        Iterator tIt = this.fitnesses.iterator();
        while (tIt.hasNext()) {
            ((Fitnesse)tIt.next()).checkConfiguration();
        }
    }

    private void changeConfigWithCmdLineParameters() {
        if (this.cmdFitnesseHostName != null || this.cmdFitnessePort != -1 || this.cmdFitnessePage != null) {
            this.getLog().info((CharSequence)"Command line parameters detected, merging with pom configuration.");
            Fitnesse tFit = this.fitnesses != null && this.fitnesses.size() > 0 ? (Fitnesse)this.fitnesses.get(0) : new Fitnesse("localhost", 80, this.cmdFitnessePage);
            this.fitnesses = new ArrayList();
            this.fitnesses.add(tFit);
            if (this.cmdFitnessePage != null) {
                tFit.setPageName(this.cmdFitnessePage);
            }
            if (this.cmdFitnesseHostName != null) {
                tFit.setHostName(this.cmdFitnesseHostName);
            }
            if (this.cmdFitnessePort != -1) {
                tFit.setPort(this.cmdFitnessePort);
            }
            this.getLog().info((CharSequence)("using url=[http://" + tFit.getHostName() + ":" + tFit.getPort() + "/" + tFit.getPageName() + "]"));
        }
    }

    public void setFitnesses(List pFitnesses) {
        this.fitnesses = pFitnesses;
    }

    protected Fitnesse getFitnesse(int pPosition) {
        return (Fitnesse)this.fitnesses.get(pPosition);
    }

    protected int getFitnesseSize() {
        return this.fitnesses.size();
    }

    UsernamePasswordCredentials getCredential(String pServerId) throws MojoExecutionException {
        UsernamePasswordCredentials tResult = null;
        Iterator tEnum = this.servers.iterator();
        while (tEnum.hasNext()) {
            Server tServer = (Server)tEnum.next();
            if (!pServerId.equals(tServer.getId())) continue;
            this.getLog().info((CharSequence)("Use login/password for user " + tServer.getUsername()));
            tResult = new UsernamePasswordCredentials(tServer.getUsername(), tServer.getPassword());
        }
        if (tResult == null) {
            throw new MojoExecutionException("Unable to find credential for ServerId=[" + pServerId + "], you must define a <Server> tag in your settings.xml for this Id.");
        }
        return tResult;
    }

    public void addServer(Server pServer) {
        this.servers.add(pServer);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    void transformHtml(InputStream pIn, Writer pOut, String pOutputFileName, String pStatus) throws IOException, MojoExecutionException {
        String tHtml = FileUtil.getString(pIn);
        int curPosStart = tHtml.indexOf("<title>") + "<title>".length();
        int curPosEnd = tHtml.indexOf("</title>");
        pOut.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" ");
        pOut.write("\"http://www.w3.org/TR/html4/strict.DTD\">\r\n");
        pOut.write("<html>\r\n");
        pOut.write("\t<head>\r\n");
        pOut.write("\t\t<title>");
        pOut.write(tHtml.substring(curPosStart, curPosEnd));
        pOut.write(" [");
        pOut.write(this.getCurrentTimeAsString());
        pOut.write("]</title>\r\n");
        pOut.write("\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"fitnesse_base.css\" ");
        pOut.write("media=\"screen\"/>\r\n");
        pOut.write("\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"fitnesse_print.css\" ");
        pOut.write("media=\"print\"/>\r\n");
        pOut.write("\t\t<script src=\"fitnesse.js\" type=\"text/javascript\"></script>\r\n");
        pOut.write("\t</head>\r\n");
        pOut.write("\t<body>\r\n");
        pOut.write("\t\t<div id=\"execution-status\">\r\n");
        pOut.write("\t\t\t<a href=\"");
        pOut.write(pOutputFileName);
        pOut.write("\"><img src=\"images/executionStatus/");
        pOut.write(this.getImage(pStatus));
        pOut.write("\"/></a>\r\n");
        pOut.write("\t\t\t<br/>\r\n");
        pOut.write("\t\t\t<a href=\"");
        pOut.write(pOutputFileName);
        pOut.write("\">Tests Executed ");
        pOut.write(pStatus);
        pOut.write("</a>\r\n");
        pOut.write("\t\t</div>\r\n");
        pOut.write("\t\t<h3>Test executed on " + this.getCurrentTimeAsString() + "</h3>\r\n");
        curPosStart = tHtml.indexOf("<div class=\"main\">");
        tHtml = tHtml.substring(curPosStart, tHtml.length());
        tHtml = tHtml.replaceAll("/files/", "");
        curPosStart = tHtml.indexOf("<div id=\"execution-status\">");
        curPosEnd = tHtml.indexOf("</div>", curPosStart);
        if (curPosStart >= 0 && curPosEnd >= 0) {
            pOut.write(tHtml.substring(0, curPosStart));
            pOut.write(tHtml.substring(curPosEnd + "</div>".length() + 2, tHtml.length()));
        } else {
            pOut.write(tHtml);
        }
        pOut.flush();
    }

    private String getImage(String pStatus) throws MojoExecutionException {
        if ("OK".equals(pStatus)) {
            return "ok.gif";
        }
        if ("Error".equals(pStatus)) {
            return "error.gif";
        }
        if ("Fail".equals(pStatus)) {
            return "output.gif";
        }
        throw new MojoExecutionException("Invalid status [" + pStatus + "]");
    }

    protected String getCurrentTimeAsString() {
        SimpleDateFormat tFormat = new SimpleDateFormat(this.dateFormat);
        return tFormat.format(new Date());
    }

    public void setDateFormat(String pDateFormat) {
        this.dateFormat = pDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    String getTmpFileName(Fitnesse pServer) {
        return this.getResultFileName(pServer, "_tmp", "html");
    }

    String getFinalFileName(Fitnesse pServer) {
        return this.getResultFileName(pServer, "", "html");
    }

    abstract String getOutputFileName(Fitnesse var1);

    abstract String getOutputUrl(Fitnesse var1);

    protected String getResultFileName(Fitnesse pServer, String pPostfix, String pExtension) {
        return this.workingDir + "/" + FITNESSE_RESULT_PREFIX + "_" + pServer.getHostName() + "_" + pServer.getPageName() + pPostfix + "." + pExtension;
    }
}

