/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.docbook;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.docbook.DocumentTransformer;
import org.codehaus.mojo.docbook.OLinkDBUpdater;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;

public class TransformMojo
extends AbstractMojo {
    private static String XERCES_PARSER_CONFIG = "org.apache.xerces.xni.parser.XMLParserConfiguration";
    private static String XERCES_XINCLUDE_PARSER = "org.apache.xerces.parsers.XIncludeParserConfiguration";
    private File sourceDirectory;
    private File resourceDirectory;
    private File databaseDirectory;
    private File outputDirectory;
    private String outputEncoding;
    private String stylesheetLocation;
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Proxy activeProxy = this.settings.getActiveProxy();
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (activeProxy != null) {
            System.setProperty("http.proxyHost", activeProxy.getHost());
            System.setProperty("http.proxyPort", new Integer(activeProxy.getPort()).toString());
            System.setProperty("http.nonProxyHosts", activeProxy.getNonProxyHosts());
        }
        String xercesParser = System.getProperty(XERCES_PARSER_CONFIG);
        System.setProperty(XERCES_PARSER_CONFIG, XERCES_XINCLUDE_PARSER);
        try {
            URI stylesheetLocationURI = new URI(this.stylesheetLocation);
            OLinkDBUpdater olinkDBUpdater = new OLinkDBUpdater(log, this.sourceDirectory, this.databaseDirectory, stylesheetLocationURI);
            DocumentTransformer documentTransformer = new DocumentTransformer(log, this.sourceDirectory, this.resourceDirectory, this.databaseDirectory, this.outputDirectory, stylesheetLocationURI);
            olinkDBUpdater.update();
            documentTransformer.transform();
        }
        catch (TransformerFactoryConfigurationError exc) {
            throw new MojoExecutionException(exc.getLocalizedMessage(), (Throwable)exc);
        }
        catch (TransformerException exc) {
            throw new MojoFailureException(exc.getLocalizedMessage());
        }
        catch (URISyntaxException exc) {
            throw new MojoExecutionException(exc.getLocalizedMessage(), (Exception)exc);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getLocalizedMessage(), (Exception)exc);
        }
        catch (InclusionScanException exc) {
            throw new MojoExecutionException(exc.getLocalizedMessage(), (Exception)((Object)exc));
        }
        finally {
            if (xercesParser != null) {
                System.setProperty(XERCES_PARSER_CONFIG, xercesParser);
            } else {
                System.setProperty(XERCES_PARSER_CONFIG, "");
            }
            if (httpProxyHost != null) {
                System.setProperty("http.proxyHost", httpProxyHost);
                System.setProperty("http.proxyPort", httpProxyPort);
                System.setProperty("http.nonProxyHosts", httpNonProxyHosts);
            } else {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                System.setProperty("http.nonProxyHosts", "");
            }
        }
    }
}

