/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimePeriod
implements Comparable {
    public static final TimePeriod MINUTE = new TimePeriod("MINUTE", new SimpleDateFormat("yyyy-MM-dd HH:mm"), 20);
    public static final TimePeriod HOUR = new TimePeriod("HOUR", new SimpleDateFormat("yyyy-MM-dd HH:00"), 30);
    public static final TimePeriod DAY = new TimePeriod("DAY", new SimpleDateFormat("yyyy-MM-dd"), 40);
    public static final TimePeriod WEEK = new TimePeriod("WEEK", new SimpleDateFormat("yyyy-MM-dd"), 47){

        public String normalizeToString(Date date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(7, calendar.getFirstDayOfWeek());
            String dateString = this.getDateFormat().format(calendar.getTime());
            return dateString;
        }
    };
    public static final TimePeriod MONTH = new TimePeriod("MONTH", new SimpleDateFormat("yyyy-MM"), 50);
    private String periodName;
    private SimpleDateFormat dateFormat;
    private Integer order;

    private TimePeriod(String period, SimpleDateFormat dateFormat, int order) {
        this.periodName = period;
        this.dateFormat = dateFormat;
        this.order = new Integer(order);
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String getName() {
        return this.periodName;
    }

    public Date normalize(Date date) {
        Date dateNormalized = null;
        try {
            dateNormalized = this.dateFormat.parse(this.normalizeToString(date));
        }
        catch (Exception e) {
            dateNormalized = date;
        }
        return dateNormalized;
    }

    public String normalizeToString(Date date) {
        return this.dateFormat.format(date);
    }

    public static TimePeriod getPeriod(String name) {
        if ("MINUTE".equalsIgnoreCase(name)) {
            return MINUTE;
        }
        if ("HOUR".equalsIgnoreCase(name)) {
            return HOUR;
        }
        if ("DAY".equalsIgnoreCase(name)) {
            return DAY;
        }
        if ("WEEK".equalsIgnoreCase(name)) {
            return WEEK;
        }
        if ("MONTH".equalsIgnoreCase(name)) {
            return MONTH;
        }
        return DAY;
    }

    public int compareTo(Object anotherPeriod) {
        return this.order.compareTo(((TimePeriod)anotherPeriod).order);
    }
}

