/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.hibernate;

import java.io.File;
import java.net.URL;
import org.codehaus.mojo.dashboard.report.plugin.hibernate.HibernateService;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class HibernateServiceImpl
implements HibernateService,
Initializable {
    private SessionFactory sessionFactory;
    private Configuration hibConfig;
    private Session session;
    private String mapping = "hibernate.cfg.xml";
    private String dialect;
    private String driverClass;
    private String url;
    private String username;
    private String password;

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            if (this.dialect != null) {
                this.hibConfig.setProperty("hibernate.dialect", this.dialect);
            }
            if (this.driverClass != null) {
                this.hibConfig.setProperty("hibernate.connection.driver_class", this.driverClass);
            }
            if (this.url != null) {
                this.hibConfig.setProperty("hibernate.connection.url", this.url);
            }
            if (this.username != null) {
                this.hibConfig.setProperty("hibernate.connection.username", this.username);
            }
            if (this.password != null) {
                this.hibConfig.setProperty("hibernate.connection.password", this.password);
            }
            try {
                this.sessionFactory = this.hibConfig.buildSessionFactory();
            }
            catch (HibernateException e) {
                throw new RuntimeException("Problem creating session factory: ", e);
            }
        }
        return this.sessionFactory;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = this.getSessionFactory().openSession();
        }
        return this.session;
    }

    public void initialize() throws InitializationException {
        block4: {
            this.hibConfig = new Configuration();
            try {
                File file = new File(this.mapping);
                if (file.exists()) {
                    this.hibConfig.configure(file);
                    break block4;
                }
                URL url = HibernateServiceImpl.class.getClassLoader().getResource(this.mapping);
                System.out.println("url = " + url);
                if (url != null) {
                    this.hibConfig.configure(url);
                    break block4;
                }
                throw new RuntimeException("Couldn't find mapping file: " + this.mapping);
            }
            catch (HibernateException e) {
                throw new InitializationException("Mapping problem.", (Throwable)e);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.hibConfig;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionUrl() {
        return this.url;
    }

    public void setConnectionUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void save(Object obj) {
        Transaction transac = this.getSession().beginTransaction();
        this.session.save(obj);
        transac.commit();
    }

    public void update(Object obj) {
        Transaction transac = this.getSession().beginTransaction();
        this.session.update(obj);
        transac.commit();
    }

    public void saveOrUpdate(Object obj) {
        Transaction transac = this.getSession().beginTransaction();
        this.session.saveOrUpdate(obj);
        transac.commit();
    }
}

